/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3498")
public class ObjectLiteralShorthandCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use shorthand for %s \"%s\".";

    public void visitPairProperty(PairPropertyTree tree) {
        if (tree.key().is(new Kinds[]{Tree.Kind.IDENTIFIER_NAME})) {
            String keyName = ((IdentifierTree)tree.key()).name();
            if (tree.value().is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && ((IdentifierTree)tree.value()).name().equals(keyName)) {
                this.raiseIssue("property", keyName, tree.key());
            }
            if (tree.value().is(new Kinds[]{Tree.Kind.FUNCTION_EXPRESSION})) {
                this.raiseIssue("method", keyName, tree.key());
            }
        }
        super.visitPairProperty(tree);
    }

    private void raiseIssue(String kind, String keyName, Tree highlighted) {
        String message = String.format(MESSAGE, kind, keyName);
        this.addIssue(highlighted, message);
    }
}

