/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.TryStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WithStatementTree;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S1105")
public class OpenCurlyBracesAtEOLCheck
extends SubscriptionVisitorCheck {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.BLOCK, (Object)Tree.Kind.OBJECT_LITERAL, (Object)Tree.Kind.SWITCH_STATEMENT, (Object)Tree.Kind.CLASS_DECLARATION, (Object)Tree.Kind.CLASS_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.BLOCK})) {
            BlockTree body = (BlockTree)tree;
            Tree parent = CheckUtils.parent((Tree)body);
            SyntaxToken openCurly = body.openCurlyBrace();
            openCurly.column();
            this.checkFunction(parent, openCurly);
            this.checkConditional(parent, openCurly);
            this.checkLoop(parent, openCurly);
            this.checkTryCatchFinally(body, parent, openCurly);
            this.checkWith(parent, openCurly);
        }
        if (tree.is(new Kinds[]{Tree.Kind.OBJECT_LITERAL})) {
            ObjectLiteralTree objectLiteral = (ObjectLiteralTree)tree;
            SyntaxToken openCurly = objectLiteral.openCurlyBrace();
            Tree parent = CheckUtils.parent((Tree)objectLiteral);
            this.checkAssignment(openCurly, parent);
        }
        if (tree.is(new Kinds[]{Tree.Kind.SWITCH_STATEMENT})) {
            this.checkSwitch((SwitchStatementTree)tree);
        }
        if (tree.is(new Kinds[]{Tree.Kind.CLASS_DECLARATION, Tree.Kind.CLASS_EXPRESSION})) {
            this.checkClass((ClassTree)tree);
        }
    }

    private void checkAssignment(SyntaxToken openCurly, Tree parent) {
        if (parent.is(new Kinds[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) {
            this.issueIfLineMismatch(openCurly, ((InitializedBindingElementTree)parent).equalToken());
        }
    }

    private void checkClass(ClassTree classTree) {
        if (classTree.extendsToken() != null) {
            this.issueIfLineMismatch(classTree.openCurlyBraceToken(), classTree.extendsToken());
        } else {
            this.issueIfLineMismatch(classTree.openCurlyBraceToken(), classTree.classToken());
        }
    }

    private void checkSwitch(SwitchStatementTree switchStatement) {
        this.issueIfLineMismatch(switchStatement.openCurlyBrace(), switchStatement.closeParenthesis());
    }

    private void checkWith(Tree parent, SyntaxToken openCurly) {
        if (parent.is(new Kinds[]{Tree.Kind.WITH_STATEMENT})) {
            this.issueIfLineMismatch(openCurly, ((WithStatementTree)parent).closingParenthesis());
        }
    }

    private void checkTryCatchFinally(BlockTree body, Tree parent, SyntaxToken openCurly) {
        if (parent.is(new Kinds[]{Tree.Kind.TRY_STATEMENT})) {
            TryStatementTree tryStatementTree = (TryStatementTree)parent;
            if (tryStatementTree.block().equals(body)) {
                this.issueIfLineMismatch(openCurly, tryStatementTree.tryKeyword());
            }
            if (body.equals(tryStatementTree.finallyBlock())) {
                this.issueIfLineMismatch(openCurly, tryStatementTree.finallyKeyword());
            }
        }
        if (parent.is(new Kinds[]{Tree.Kind.CATCH_BLOCK})) {
            this.issueIfLineMismatch(openCurly, ((CatchBlockTree)parent).catchKeyword());
        }
    }

    private void checkLoop(Tree parent, SyntaxToken openCurly) {
        if (parent.is(new Kinds[]{Tree.Kind.DO_WHILE_STATEMENT})) {
            this.issueIfLineMismatch(openCurly, ((DoWhileStatementTree)parent).doKeyword());
        }
        if (parent.is(new Kinds[]{Tree.Kind.WHILE_STATEMENT})) {
            this.issueIfLineMismatch(openCurly, ((WhileStatementTree)parent).closeParenthesis());
        }
        if (parent.is(new Kinds[]{Tree.Kind.FOR_STATEMENT})) {
            this.issueIfLineMismatch(openCurly, ((ForStatementTree)parent).closeParenthesis());
        }
        if (parent.is(new Kinds[]{Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT})) {
            this.issueIfLineMismatch(openCurly, ((ForObjectStatementTree)parent).closeParenthesis());
        }
    }

    private void checkConditional(Tree parent, SyntaxToken openCurly) {
        if (parent.is(new Kinds[]{Tree.Kind.IF_STATEMENT})) {
            this.issueIfLineMismatch(openCurly, ((IfStatementTree)parent).closeParenthesis());
        }
        if (parent.is(new Kinds[]{Tree.Kind.ELSE_CLAUSE})) {
            this.issueIfLineMismatch(openCurly, ((ElseClauseTree)parent).elseKeyword());
        }
    }

    private void checkFunction(Tree parent, SyntaxToken openCurly) {
        if (parent.is(new Kinds[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.METHOD, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION})) {
            this.issueIfLineMismatch(openCurly, OpenCurlyBracesAtEOLCheck.getParameterList((FunctionTree)parent).closeParenthesis());
        }
        if (parent.is(new Kinds[]{Tree.Kind.ARROW_FUNCTION})) {
            this.issueIfLineMismatch(openCurly, ((ArrowFunctionTree)parent).doubleArrow());
        }
    }

    private static ParameterListTree getParameterList(FunctionTree parent) {
        return (ParameterListTree)parent.parameterClause();
    }

    private void issueIfLineMismatch(SyntaxToken curlyBrace, SyntaxToken target) {
        CodeLine curlyBraceLine = new CodeLine(curlyBrace.line());
        if (curlyBraceLine.isJustBelow(target.line())) {
            this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, new IssueLocation((Tree)curlyBrace, "Move this open curly brace to the end of the previous line.")));
        } else if (curlyBraceLine.isFarBelow(target.line())) {
            this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, new IssueLocation((Tree)curlyBrace, "Move this open curly brace to the end of line " + target.line() + ".")));
        }
    }

    private static class CodeLine {
        private final int line;

        CodeLine(int line) {
            this.line = line;
        }

        boolean isJustBelow(int line) {
            return this.line == line + 1;
        }

        boolean isFarBelow(int line) {
            return this.line > line + 1;
        }
    }
}

