/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAnyPathSeCheck;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.se.sv.BuiltInFunctionSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.impl.expression.CallExpressionTreeImpl;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;

@Rule(key="S2201")
public class ReturnValueNotIgnoredCheck
extends AbstractAnyPathSeCheck {
    private static final String MESSAGE = "The return value of \"%s\" must be used.";

    public void beforeBlockElement(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        CallExpressionTreeImpl callExpression;
        JavaScriptTree parent;
        if (element.is(new Kinds[]{Tree.Kind.CALL_EXPRESSION}) && (parent = (callExpression = (CallExpressionTreeImpl)element).getParent()).is(new Kinds[]{Tree.Kind.EXPRESSION_STATEMENT}) && ReturnValueNotIgnoredCheck.isExemptFromSideEffects((CallExpressionTree)callExpression, currentState)) {
            String message = String.format(MESSAGE, ReturnValueNotIgnoredCheck.getCalleeName((CallExpressionTree)callExpression));
            this.addUniqueIssue((Tree)callExpression, message);
        }
    }

    private static boolean isExemptFromSideEffects(CallExpressionTree callExpression, ProgramState state) {
        SeparatedList arguments = callExpression.arguments().parameters();
        SymbolicValue calleeValue = state.peekStack(arguments.size());
        if (calleeValue instanceof BuiltInFunctionSymbolicValue) {
            BuiltInFunctionSymbolicValue builtInFunction = (BuiltInFunctionSymbolicValue)calleeValue;
            return !builtInFunction.hasSideEffect();
        }
        return false;
    }

    private static String getCalleeName(CallExpressionTree callExpression) {
        ExpressionTree callee = CheckUtils.removeParenthesis(callExpression.callee());
        if (callee.is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            return ((DotMemberExpressionTree)callee).property().name();
        }
        return CheckUtils.asString((Tree)callee);
    }
}

