/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1656")
public class SelfAssignmentCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove or correct this useless self-assignment.";

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        if (tree.is(new Kinds[]{Tree.Kind.ASSIGNMENT}) && SyntacticEquivalence.areEquivalent((Tree)variable, (Tree)tree.expression())) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitAssignmentExpression(tree);
    }
}

