/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="StrictMode")
public class StrictModeCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use of JavaScript strict mode may result in unexpected behaviour in some browsers.";

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        String value;
        if (tree.expression().is(new Kinds[]{Tree.Kind.STRING_LITERAL}) && ("\"use strict\"".equals(value = ((LiteralTree)tree.expression()).value()) || "'use strict'".equals(value))) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitExpressionStatement(tree);
    }
}

