/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAllPathSeCheck;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.Type;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;

@Rule(key="S3402")
public class StringConcatenatedWithNonStringCheck
extends AbstractAllPathSeCheck<BinaryExpressionTree> {
    private static final String MESSAGE = "Either make this concatenation explicit or cast one operand to a number.";

    @Override
    BinaryExpressionTree getTree(Tree element) {
        if (element.is(new Kinds[]{Tree.Kind.PLUS})) {
            return (BinaryExpressionTree)element;
        }
        return null;
    }

    @Override
    boolean isProblem(BinaryExpressionTree tree, ProgramState currentState) {
        ExpressionTree onlyStringOperand = StringConcatenatedWithNonStringCheck.getOnlyStringOperand(tree.leftOperand(), tree.rightOperand(), currentState);
        return onlyStringOperand != null && onlyStringOperand.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE});
    }

    @Override
    void raiseIssue(BinaryExpressionTree tree) {
        this.addIssue((Tree)tree.operator(), MESSAGE).secondary((Tree)tree.leftOperand()).secondary((Tree)tree.rightOperand());
    }

    @CheckForNull
    private static ExpressionTree getOnlyStringOperand(ExpressionTree leftOperand, ExpressionTree rightOperand, ProgramState currentState) {
        Constraint rightConstraint = currentState.getConstraint(currentState.peekStack(0));
        Constraint leftConstraint = currentState.getConstraint(currentState.peekStack(1));
        Type rightType = rightConstraint.type();
        Type leftType = leftConstraint.type();
        if (leftType != null && rightType != null) {
            if (leftConstraint.isStricterOrEqualTo(Constraint.ANY_STRING) && !rightConstraint.isStricterOrEqualTo(Constraint.ANY_STRING)) {
                return leftOperand;
            }
            if (!leftConstraint.isStricterOrEqualTo(Constraint.ANY_STRING) && rightConstraint.isStricterOrEqualTo(Constraint.ANY_STRING)) {
                return rightOperand;
            }
        }
        return null;
    }
}

