/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.javascript.tree.impl.expression.SuperTreeImpl;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S3854")
public class SuperInvocationCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE_SUPER_ONLY_IN_DERIVED_CLASS_CONSTRUCTOR = "super() can only be invoked in a derived class constructor.";
    private static final String MESSAGE_SUPER_REQUIRED_IN_ANY_DERIVED_CLASS_CONSTRUCTOR = "super() must be invoked in any derived class constructor.";
    private static final String MESSAGE_SUPER_BEFORE_THIS_OR_SUPER = "super() must be invoked before \"this\" or \"super\" can be used.";
    private static final String MESSAGE_SUPER_WITH_CORRECT_NUMBER_OF_ARGUMENTS = "super() must be invoked with %s argument%s.";
    private static final String MESSAGE_SUPER_INVOKED_ONCE = "super() can only be invoked once.";
    private Deque<List<SuperTreeImpl>> superInvocations = new LinkedList<List<SuperTreeImpl>>();

    public void visitScript(ScriptTree tree) {
        this.superInvocations.clear();
        super.visitScript(tree);
    }

    public void visitSuper(SuperTreeImpl tree) {
        if (tree.getParent().is(new Kinds[]{Tree.Kind.CALL_EXPRESSION})) {
            if (!SuperInvocationCheck.isInConstructor((Tree)tree) || SuperInvocationCheck.isInBaseClass(SuperInvocationCheck.getEnclosingConstructor((Tree)tree))) {
                this.checkSuperOnlyInvokedInDerivedClassConstructor(tree);
            } else {
                this.checkSuperInvokedBeforeThisOrSuper(tree);
                this.checkSuperHasCorrectNumberOfArguments(tree);
            }
            this.pushSuperInvocation(tree);
        }
        super.visitSuper(tree);
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkSuperInvokedInAnyDerivedClassConstructor(tree);
        this.superInvocations.push(new LinkedList());
        super.visitMethodDeclaration(tree);
        this.checkSuperInvokedOnlyOnce(tree, this.superInvocations.pop());
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.superInvocations.push(new LinkedList());
        super.visitFunctionDeclaration(tree);
        this.superInvocations.pop();
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.superInvocations.push(new LinkedList());
        super.visitFunctionExpression(tree);
        this.superInvocations.pop();
    }

    private void checkSuperOnlyInvokedInDerivedClassConstructor(SuperTreeImpl superTree) {
        this.addIssue((Tree)superTree, MESSAGE_SUPER_ONLY_IN_DERIVED_CLASS_CONSTRUCTOR);
    }

    private void checkSuperInvokedInAnyDerivedClassConstructor(MethodDeclarationTree method) {
        Set<SuperTreeImpl> superTrees;
        if (SuperInvocationCheck.isConstructor((FunctionTree)method) && !SuperInvocationCheck.isInBaseClass(method) && !SuperInvocationCheck.isInDummyDerivedClass(method) && (superTrees = new SuperDetector().detectIn((FunctionTree)method)).stream().noneMatch(s -> s.getParent().is(new Kinds[]{Tree.Kind.CALL_EXPRESSION}))) {
            this.addIssue(method.name(), MESSAGE_SUPER_REQUIRED_IN_ANY_DERIVED_CLASS_CONSTRUCTOR);
        }
    }

    private void checkSuperInvokedBeforeThisOrSuper(SuperTreeImpl superTree) {
        int line = superTree.getFirstToken().line();
        int column = superTree.getFirstToken().column();
        MethodDeclarationTree method = SuperInvocationCheck.getEnclosingConstructor((Tree)superTree);
        HashSet secondaryLocations = new HashSet();
        Set<SuperTreeImpl> superTrees = new SuperDetector().detectIn((FunctionTree)method);
        superTrees.stream().filter(s -> !s.getParent().is(new Kinds[]{Tree.Kind.CALL_EXPRESSION})).filter(s -> SuperInvocationCheck.isBefore(s.getFirstToken(), line, column)).map(IssueLocation::new).forEach(secondaryLocations::add);
        Set<IdentifierTree> thisTrees = new ThisDetector().detectIn((FunctionTree)method);
        thisTrees.stream().filter(s -> SuperInvocationCheck.isBefore(s.identifierToken(), line, column)).map(IssueLocation::new).forEach(secondaryLocations::add);
        if (!secondaryLocations.isEmpty()) {
            PreciseIssue issue = this.addIssue((Tree)superTree, MESSAGE_SUPER_BEFORE_THIS_OR_SUPER);
            secondaryLocations.forEach(arg_0 -> ((PreciseIssue)issue).secondary(arg_0));
        }
    }

    private void checkSuperHasCorrectNumberOfArguments(SuperTreeImpl superTree) {
        Symbol superClassSymbol;
        ClassTree classTree = SuperInvocationCheck.getEnclosingClass((Tree)superTree);
        ExpressionTree superClassTree = classTree.superClass();
        if (superClassTree.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && (superClassSymbol = ((IdentifierTree)superClassTree).symbol()) != null) {
            this.compareNumberOfArguments(superTree, superClassSymbol);
        }
    }

    private void checkSuperInvokedOnlyOnce(MethodDeclarationTree tree, List<SuperTreeImpl> superTrees) {
        if (SuperInvocationCheck.isConstructor((FunctionTree)tree) && superTrees.size() > 1) {
            SuperTreeImpl firstSuper = superTrees.get(0);
            superTrees.stream().skip(1L).forEach(s -> this.addIssue((Tree)s, MESSAGE_SUPER_INVOKED_ONCE).secondary(new IssueLocation((Tree)firstSuper)));
        }
    }

    private void pushSuperInvocation(SuperTreeImpl tree) {
        if (this.superInvocations.peek() != null) {
            this.superInvocations.peek().add(tree);
        }
    }

    private void compareNumberOfArguments(SuperTreeImpl superTree, Symbol superClassSymbol) {
        Optional<MethodDeclarationTree> baseClassConstructor;
        Optional<ClassTree> baseClassTree = SuperInvocationCheck.getDeclarationTree(superClassSymbol);
        if (baseClassTree.isPresent() && (baseClassConstructor = SuperInvocationCheck.getConstructor(baseClassTree.get())).isPresent()) {
            Integer nbParams = baseClassConstructor.get().parameterList().size();
            int nbArguments = ((CallExpressionTree)superTree.getParent()).arguments().parameters().size();
            if (nbArguments != nbParams) {
                String message = String.format(MESSAGE_SUPER_WITH_CORRECT_NUMBER_OF_ARGUMENTS, nbParams, nbParams == 1 ? "" : "s");
                this.addIssue(CheckUtils.parent((Tree)superTree), message).secondary((Tree)baseClassConstructor.get().parameterClause());
            }
        }
    }

    private static Optional<MethodDeclarationTree> getConstructor(ClassTree classTree) {
        return classTree.elements().stream().filter(t -> t.is(new Kinds[]{Tree.Kind.METHOD})).map(t -> (MethodDeclarationTree)t).filter(SuperInvocationCheck::isConstructor).findAny();
    }

    private static Optional<ClassTree> getDeclarationTree(Symbol symbol) {
        Optional<Usage> tree = symbol.usages().stream().filter(Usage::isDeclaration).findFirst();
        if (tree.isPresent()) {
            IdentifierTree id = tree.get().identifierTree();
            Tree parent = CheckUtils.parent((Tree)id);
            if (parent.is(new Kinds[]{Tree.Kind.CLASS_DECLARATION, Tree.Kind.CLASS_EXPRESSION})) {
                return Optional.of((ClassTree)parent);
            }
        }
        return Optional.empty();
    }

    private static boolean isBefore(SyntaxToken token, int line, int column) {
        if (token.line() < line) {
            return true;
        }
        if (token.line() > line) {
            return false;
        }
        return token.column() < column;
    }

    private static boolean isInConstructor(Tree tree) {
        return SuperInvocationCheck.getEnclosingConstructor(tree) != null;
    }

    private static boolean isInBaseClass(MethodDeclarationTree method) {
        ClassTree classTree = SuperInvocationCheck.getEnclosingClass((Tree)method);
        return classTree.extendsToken() == null;
    }

    private static boolean isInDummyDerivedClass(MethodDeclarationTree method) {
        ClassTree classTree = SuperInvocationCheck.getEnclosingClass((Tree)method);
        return classTree.superClass().is(new Kinds[]{Tree.Kind.NULL_LITERAL});
    }

    @CheckForNull
    private static MethodDeclarationTree getEnclosingConstructor(Tree tree) {
        FunctionTree function = (FunctionTree)CheckUtils.getFirstAncestor(tree, new Kinds[]{KindSet.FUNCTION_KINDS});
        if (function != null && SuperInvocationCheck.isConstructor(function)) {
            return (MethodDeclarationTree)function;
        }
        return null;
    }

    private static boolean isConstructor(FunctionTree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.METHOD})) {
            MethodDeclarationTree constructor = (MethodDeclarationTree)tree;
            Tree nameTree = constructor.name();
            if (nameTree.is(new Kinds[]{Tree.Kind.IDENTIFIER_NAME})) {
                String name = ((IdentifierTree)nameTree).name();
                return "constructor".equals(name);
            }
        }
        return false;
    }

    private static ClassTree getEnclosingClass(Tree tree) {
        return (ClassTree)CheckUtils.getFirstAncestor(tree, new Kinds[]{Tree.Kind.CLASS_DECLARATION, Tree.Kind.CLASS_EXPRESSION});
    }

    private static class ThisDetector
    extends DoubleDispatchVisitor {
        private Set<IdentifierTree> collectionOfThiss = new HashSet<IdentifierTree>();

        private ThisDetector() {
        }

        public Set<IdentifierTree> detectIn(FunctionTree function) {
            this.collectionOfThiss.clear();
            this.scan((Tree)function);
            return this.collectionOfThiss;
        }

        public void visitIdentifier(IdentifierTree identifier) {
            if (identifier.is(new Kinds[]{Tree.Kind.THIS})) {
                this.collectionOfThiss.add(identifier);
            }
        }
    }

    private static class SuperDetector
    extends DoubleDispatchVisitor {
        private Set<SuperTreeImpl> collectionOfSupers = new HashSet<SuperTreeImpl>();

        private SuperDetector() {
        }

        public Set<SuperTreeImpl> detectIn(FunctionTree function) {
            this.collectionOfSupers.clear();
            this.scan((Tree)function);
            return this.collectionOfSupers;
        }

        public void visitSuper(SuperTreeImpl superTree) {
            this.collectionOfSupers.add(superTree);
        }
    }
}

