/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.statement.VariableDeclarationTreeImpl;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ArrayBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.declaration.ObjectBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3353")
public class UnchangedLetVariableCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Make \"%s\" \"const\".";
    private Set<Symbol> ignoredSymbols;

    public void visitScript(ScriptTree tree) {
        this.ignoredSymbols = new HashSet<Symbol>();
        super.visitScript(tree);
        for (Symbol letVariableSymbol : this.getContext().getSymbolModel().getSymbols(Symbol.Kind.LET_VARIABLE)) {
            if (this.ignoredSymbols.contains(letVariableSymbol)) continue;
            boolean isWritten = false;
            Usage declarationWithInit = null;
            for (Usage usage : letVariableSymbol.usages()) {
                if (usage.kind() == Usage.Kind.DECLARATION_WRITE) {
                    declarationWithInit = usage;
                    continue;
                }
                if (!usage.isWrite()) continue;
                isWritten = true;
            }
            if (declarationWithInit == null || isWritten || letVariableSymbol.usages().size() <= 1) continue;
            this.addIssue((Tree)declarationWithInit.identifierTree(), String.format(MESSAGE, letVariableSymbol.name()));
        }
    }

    public void visitForStatement(ForStatementTree tree) {
        Tree init = tree.init();
        if (init != null && init.is(new Kinds[]{Tree.Kind.LET_DECLARATION})) {
            List identifiers = ((VariableDeclarationTreeImpl)init).variableIdentifiers();
            this.ignore(identifiers);
        }
        super.visitForStatement(tree);
    }

    public void visitArrayBindingPattern(ArrayBindingPatternTree tree) {
        this.ignore(tree.bindingIdentifiers());
    }

    public void visitObjectBindingPattern(ObjectBindingPatternTree tree) {
        this.ignore(tree.bindingIdentifiers());
    }

    private void ignore(List<IdentifierTree> identifiers) {
        if (identifiers.size() > 1) {
            identifiers.stream().map(IdentifierTree::symbol).forEach(this.ignoredSymbols::add);
        }
    }
}

