/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ObjectBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="UnusedVariable")
public class UnusedVariableCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE_FOR_VARIABLE = "Remove the declaration of the unused '%s' variable.";
    private static final String MESSAGE_FOR_FUNCTION = "Remove unused function '%s'.";
    private Set<Symbol> ignoredSymbols;

    public void visitObjectBindingPattern(ObjectBindingPatternTree tree) {
        super.visitObjectBindingPattern(tree);
        if (tree.elements().isEmpty()) {
            return;
        }
        BindingElementTree lastElement = (BindingElementTree)tree.elements().get(tree.elements().size() - 1);
        if (lastElement.is(new Kinds[]{Tree.Kind.REST_ELEMENT})) {
            for (int i = 0; i < tree.elements().size() - 1; ++i) {
                BindingElementTree currentElement = (BindingElementTree)tree.elements().get(i);
                if (!currentElement.is(new Kinds[]{Tree.Kind.BINDING_IDENTIFIER})) continue;
                this.ignoredSymbols.add(((IdentifierTree)currentElement).symbol());
            }
        }
    }

    public void visitScript(ScriptTree tree) {
        this.ignoredSymbols = new HashSet<Symbol>();
        super.visitScript(tree);
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        for (Symbol symbol : symbolModel.getSymbols()) {
            Collection usages;
            if (this.ignoredSymbols.contains(symbol) || UnusedVariableCheck.isFunctionExpression(symbol) || !UnusedVariableCheck.noUsages(usages = symbol.usages()) || UnusedVariableCheck.isGlobalOrCatchVariable(symbol) || symbol.external()) continue;
            if (symbol.isVariable()) {
                this.raiseIssuesOnDeclarations(symbol, String.format(MESSAGE_FOR_VARIABLE, symbol.name()));
                continue;
            }
            if (!symbol.is(Symbol.Kind.FUNCTION)) continue;
            this.raiseIssuesOnDeclarations(symbol, String.format(MESSAGE_FOR_FUNCTION, symbol.name()));
        }
    }

    private static boolean isFunctionExpression(Symbol symbol) {
        FunctionType functionType = (FunctionType)symbol.types().getUniqueType(Type.Kind.FUNCTION);
        return functionType != null && symbol.is(Symbol.Kind.FUNCTION) && functionType.functionTree().is(new Kinds[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION});
    }

    private void raiseIssuesOnDeclarations(Symbol symbol, String message) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration()) continue;
            this.addIssue((Tree)usage.identifierTree(), message);
        }
    }

    private static boolean noUsages(Collection<Usage> usages) {
        return usages.isEmpty() || UnusedVariableCheck.usagesAreInitializations(usages);
    }

    private static boolean usagesAreInitializations(Collection<Usage> usages) {
        for (Usage usage : usages) {
            if (usage.isDeclaration()) continue;
            return false;
        }
        return true;
    }

    private static boolean isGlobalOrCatchVariable(Symbol symbol) {
        return symbol.scope().tree().is(new Kinds[]{Tree.Kind.SCRIPT, Tree.Kind.CATCH_BLOCK});
    }
}

