/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.tree.symbols.type.ObjectType;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S2817")
public class WebSQLDatabaseCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Convert this use of a Web SQL database to another technology";
    private static final String OPEN_DATABASE = "openDatabase";

    public void visitCallExpression(CallExpressionTree tree) {
        ExpressionTree callee = tree.callee();
        if (WebSQLDatabaseCheck.isOpenDatabase(callee)) {
            this.addIssue((Tree)tree.callee(), MESSAGE);
        } else if (callee.is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            boolean isWindowObject;
            MemberExpressionTree memberExpr = (MemberExpressionTree)callee;
            boolean bl = isWindowObject = memberExpr.object().types().contains((Object)ObjectType.WebApiType.WINDOW) || memberExpr.object().is(new Kinds[]{Tree.Kind.THIS});
            if (isWindowObject && WebSQLDatabaseCheck.isOpenDatabase(memberExpr.property())) {
                this.addIssue((Tree)memberExpr.property(), MESSAGE);
            }
        }
        super.visitCallExpression(tree);
    }

    private static boolean isOpenDatabase(ExpressionTree callee) {
        return callee.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.IDENTIFIER_NAME}) && ((IdentifierTree)callee).name().equals(OPEN_DATABASE);
    }
}

