/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.YieldExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3828")
public class YieldOutsideGeneratorCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this \"yield\" expression or move it into a generator.";

    public void visitYieldExpression(YieldExpressionTree tree) {
        Tree firstFunctionAncestor = CheckUtils.getFirstAncestor((Tree)tree, new Kinds[]{KindSet.FUNCTION_KINDS});
        if (firstFunctionAncestor == null || !YieldOutsideGeneratorCheck.isGenerator(firstFunctionAncestor)) {
            this.addIssue((Tree)tree.yieldKeyword(), MESSAGE);
        }
        super.visitYieldExpression(tree);
    }

    private static boolean isGenerator(Tree tree) {
        return tree.is(new Kinds[]{Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_METHOD});
    }
}

