/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

public abstract class AbstractSymbolNameCheck
extends DoubleDispatchVisitorCheck {
    abstract List<String> illegalNames();

    abstract String getMessage(Symbol var1);

    public void visitScript(ScriptTree tree) {
        for (Symbol symbol : this.getIllegalSymbols()) {
            this.raiseIssuesOnDeclarations(symbol, this.getMessage(symbol));
        }
    }

    protected List<Symbol> getIllegalSymbols() {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        LinkedList<Symbol> symbols = new LinkedList<Symbol>();
        for (String name : this.illegalNames()) {
            symbols.addAll(symbolModel.getSymbols(name));
        }
        return symbols;
    }

    protected void raiseIssuesOnDeclarations(Symbol symbol, String message) {
        Preconditions.checkArgument((!symbol.external() ? 1 : 0) != 0);
        boolean issueRaised = false;
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration()) continue;
            this.addIssue((Tree)usage.identifierTree(), message);
            issueRaised = true;
        }
        if (!issueRaised) {
            this.addIssue((Tree)((Usage)symbol.usages().iterator().next()).identifierTree(), message);
        }
    }
}

