/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="AssignmentWithinCondition")
public class AssignmentWithinConditionCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Extract the assignment of \"%s\" from this expression.";

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.scan((Tree)tree.statement());
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.scan((Tree)tree.statement());
    }

    public void visitInitializedBindingElement(InitializedBindingElementTree tree) {
        this.scan((Tree)tree.left());
        this.visitInitialisationExpression(tree.right());
    }

    private void visitInitialisationExpression(ExpressionTree left) {
        if (left instanceof AssignmentExpressionTree) {
            this.scan((Tree)((AssignmentExpressionTree)left).variable());
            this.visitInitialisationExpression(((AssignmentExpressionTree)left).expression());
        } else {
            this.scan((Tree)left);
        }
    }

    public void visitForStatement(ForStatementTree tree) {
        this.visitCommaOperatorExpression(tree.init());
        this.scan((Tree)tree.condition());
        this.scan((Tree)tree.statement());
    }

    public void visitArrowFunction(ArrowFunctionTree lambdaExpressionTree) {
        if (!(lambdaExpressionTree.body() instanceof AssignmentExpressionTree)) {
            super.visitArrowFunction(lambdaExpressionTree);
        }
    }

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        Tree expressionTree = tree.expression();
        if (expressionTree.is(new Kinds[]{Tree.Kind.COMMA_OPERATOR})) {
            this.visitCommaOperatorExpression((Tree)((BinaryExpressionTree)expressionTree).leftOperand());
            this.visitCommaOperatorExpression((Tree)((BinaryExpressionTree)expressionTree).rightOperand());
        } else {
            while (expressionTree instanceof AssignmentExpressionTree) {
                AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)expressionTree;
                this.scan((Tree)assignmentExpressionTree.variable());
                expressionTree = assignmentExpressionTree.expression();
            }
            this.scan(expressionTree);
        }
    }

    public void visitCommaOperatorExpression(@Nullable Tree expression) {
        if (expression == null) {
            return;
        }
        if (expression.is(new Kinds[]{Tree.Kind.COMMA_OPERATOR})) {
            this.visitCommaOperatorExpression((Tree)((BinaryExpressionTree)expression).leftOperand());
            this.visitCommaOperatorExpression((Tree)((BinaryExpressionTree)expression).rightOperand());
        } else if (expression instanceof AssignmentExpressionTree) {
            super.visitAssignmentExpression((AssignmentExpressionTree)expression);
        } else {
            this.scan(expression);
        }
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (AssignmentWithinConditionCheck.isRelationalExpression((Tree)tree)) {
            this.visitInnerExpression(tree.leftOperand());
            this.visitInnerExpression(tree.rightOperand());
        } else {
            super.visitBinaryExpression(tree);
        }
    }

    private void visitInnerExpression(ExpressionTree tree) {
        AssignmentExpressionTree assignmentExpressionTree = AssignmentWithinConditionCheck.getInnerAssignmentExpression(tree);
        if (assignmentExpressionTree != null) {
            super.visitAssignmentExpression(assignmentExpressionTree);
        } else {
            this.scan((Tree)tree);
        }
    }

    @Nullable
    private static AssignmentExpressionTree getInnerAssignmentExpression(ExpressionTree tree) {
        ParenthesisedExpressionTree parenthesizedTree;
        if (tree.is(new Kinds[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && (parenthesizedTree = (ParenthesisedExpressionTree)tree).expression() instanceof AssignmentExpressionTree) {
            return (AssignmentExpressionTree)parenthesizedTree.expression();
        }
        return null;
    }

    private static boolean isRelationalExpression(Tree tree) {
        return tree.is(new Kinds[]{Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.RELATIONAL_IN});
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        String message = String.format(MESSAGE, CheckUtils.asString((Tree)tree.variable()));
        this.addIssue((Tree)tree.operator(), message);
    }
}

