/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S3776")
public class CognitiveComplexityFunctionCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Refactor this function to reduce its Cognitive Complexity from %s to the %s allowed.";
    private static final int DEFAULT_THRESHOLD = 15;
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    private int threshold = 15;
    private Set<Tree> ignoredNestedFunctions = new HashSet<Tree>();
    private final CognitiveComplexity cognitiveComplexity = new CognitiveComplexity();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.copyOf((Collection)KindSet.FUNCTION_KINDS.getSubKinds());
    }

    public void visitFile(Tree scriptTree) {
        this.ignoredNestedFunctions.clear();
        this.cognitiveComplexity.clear();
        super.visitFile(scriptTree);
    }

    public void visitNode(Tree tree) {
        if (!this.ignoredNestedFunctions.contains(tree)) {
            ComplexityData complexityData = this.cognitiveComplexity.calculateComplexity(tree);
            this.ignoredNestedFunctions.addAll(complexityData.aggregatedNestedFunctions());
            if (complexityData.complexity > this.threshold) {
                this.raiseIssue(complexityData, tree);
            }
        }
    }

    private void raiseIssue(ComplexityData complexityData, Tree function) {
        String message = String.format(MESSAGE, complexityData.complexity(), this.threshold);
        SyntaxToken primaryLocation = ((JavaScriptTree)function).getFirstToken();
        if (function.is(new Kinds[]{Tree.Kind.ARROW_FUNCTION})) {
            primaryLocation = ((ArrowFunctionTree)function).doubleArrow();
        }
        PreciseIssue issue = this.addIssue((Tree)primaryLocation, message).cost((double)complexityData.complexity() - (double)this.threshold);
        complexityData.secondaryLocations().forEach(arg_0 -> ((PreciseIssue)issue).secondary(arg_0));
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    private static class ComplexityData {
        private int complexity;
        private List<IssueLocation> secondaryLocations;
        private Set<Tree> aggregatedNestedFunctions;

        ComplexityData(int complexity, List<IssueLocation> secondaryLocations, Set<Tree> aggregatedNestedFunctions) {
            this.complexity = complexity;
            this.secondaryLocations = secondaryLocations;
            this.aggregatedNestedFunctions = aggregatedNestedFunctions;
        }

        int complexity() {
            return this.complexity;
        }

        List<IssueLocation> secondaryLocations() {
            return this.secondaryLocations;
        }

        Set<Tree> aggregatedNestedFunctions() {
            return this.aggregatedNestedFunctions;
        }
    }

    private static class CognitiveComplexity
    extends DoubleDispatchVisitor {
        private int nestingLevel;
        private int ownComplexity;
        private int nestedFunctionComplexity;
        private boolean functionContainsStructuralComplexity;
        private List<IssueLocation> secondaryIssueLocations = new ArrayList<IssueLocation>();
        private Tree currentFunction = null;
        private Set<Tree> nestedFunctions = new HashSet<Tree>();
        private Deque<Tree> functionStack = new ArrayDeque<Tree>();
        private Set<Tree> logicalOperationsToIgnore = new HashSet<Tree>();

        private CognitiveComplexity() {
        }

        public ComplexityData calculateComplexity(Tree functionTree) {
            functionTree.accept((DoubleDispatchVisitor)this);
            return this.buildComplexityData();
        }

        private void visitFunction(FunctionTree tree) {
            if (this.currentFunction == null) {
                this.initComplexityCalculation(tree);
            } else {
                this.nestedFunctions.add((Tree)tree);
                this.functionStack.push((Tree)tree);
                ++this.nestingLevel;
            }
        }

        public void clear() {
            this.currentFunction = null;
        }

        private void initComplexityCalculation(FunctionTree tree) {
            this.nestingLevel = 0;
            this.secondaryIssueLocations.clear();
            this.ownComplexity = 0;
            this.nestedFunctionComplexity = 0;
            this.functionContainsStructuralComplexity = false;
            this.currentFunction = tree;
            this.nestedFunctions.clear();
            this.logicalOperationsToIgnore.clear();
            this.functionStack.clear();
            this.functionStack.push(this.currentFunction);
        }

        private void leaveFunction(FunctionTree tree) {
            if (tree.equals(this.currentFunction)) {
                this.currentFunction = null;
            } else {
                --this.nestingLevel;
                this.functionStack.pop();
            }
        }

        private ComplexityData buildComplexityData() {
            int complexity;
            HashSet<Tree> aggregatedNestedFunctions = new HashSet<Tree>();
            if (this.functionContainsStructuralComplexity) {
                complexity = this.ownComplexity + this.nestedFunctionComplexity;
                aggregatedNestedFunctions.addAll(this.nestedFunctions);
            } else {
                complexity = this.ownComplexity;
            }
            return new ComplexityData(complexity, this.secondaryIssueLocations, aggregatedNestedFunctions);
        }

        public void visitIfStatement(IfStatementTree tree) {
            if (CognitiveComplexity.isElseIf(tree)) {
                this.addComplexityWithoutNesting(tree.ifKeyword());
            } else {
                this.addComplexityWithNesting(tree.ifKeyword());
            }
            this.visit(new Tree[]{tree.condition()});
            this.visitWithNesting((Tree)tree.statement());
            this.visit(new Tree[]{tree.elseClause()});
        }

        public void visitElseClause(ElseClauseTree tree) {
            if (tree.statement().is(new Kinds[]{Tree.Kind.IF_STATEMENT})) {
                this.visit(new Tree[]{tree.statement()});
            } else {
                this.addComplexityWithoutNesting(tree.elseKeyword());
                this.visitWithNesting((Tree)tree.statement());
            }
        }

        public void visitWhileStatement(WhileStatementTree tree) {
            this.visitLoop(tree.whileKeyword(), (Tree)tree.statement(), new Tree[]{tree.condition()});
        }

        public void visitDoWhileStatement(DoWhileStatementTree tree) {
            this.visitLoop(tree.doKeyword(), (Tree)tree.statement(), new Tree[]{tree.condition()});
        }

        public void visitForStatement(ForStatementTree tree) {
            this.visitLoop(tree.forKeyword(), (Tree)tree.statement(), new Tree[]{tree.init(), tree.condition(), tree.update()});
        }

        public void visitForObjectStatement(ForObjectStatementTree tree) {
            this.visitLoop(tree.forKeyword(), (Tree)tree.statement(), new Tree[]{tree.variableOrExpression(), tree.expression()});
        }

        private void visitLoop(SyntaxToken secondaryLocationToken, Tree loopBody, Tree ... notNestedElements) {
            this.addComplexityWithNesting(secondaryLocationToken);
            this.visit(notNestedElements);
            this.visitWithNesting(loopBody);
        }

        public void visitCatchBlock(CatchBlockTree tree) {
            this.addComplexityWithNesting(tree.catchKeyword());
            this.visitWithNesting((Tree)tree.block());
        }

        public void visitSwitchStatement(SwitchStatementTree tree) {
            this.addComplexityWithNesting(tree.switchKeyword());
            ++this.nestingLevel;
            super.visitSwitchStatement(tree);
            --this.nestingLevel;
        }

        public void visitBinaryExpression(BinaryExpressionTree tree) {
            if (tree.is(new Kinds[]{Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR})) {
                JavaScriptTree javaScriptTree = (JavaScriptTree)tree;
                ExpressionTree leftChild = CheckUtils.removeParenthesis(tree.leftOperand());
                ExpressionTree rightChild = CheckUtils.removeParenthesis(tree.rightOperand());
                boolean leftChildOfSameKind = leftChild.is(new Kinds[]{javaScriptTree.getKind()});
                boolean rightChildOfSameKind = rightChild.is(new Kinds[]{javaScriptTree.getKind()});
                if (rightChildOfSameKind) {
                    this.logicalOperationsToIgnore.add((Tree)rightChild);
                }
                if (!this.logicalOperationsToIgnore.contains(tree) && !leftChildOfSameKind) {
                    this.addComplexityWithoutNesting(tree.operator());
                }
            }
            super.visitBinaryExpression(tree);
        }

        public void visitConditionalExpression(ConditionalExpressionTree tree) {
            this.addComplexityWithNesting(tree.query());
            this.visit(new Tree[]{tree.condition()});
            this.visitWithNesting((Tree)tree.trueExpression());
            this.visitWithNesting((Tree)tree.falseExpression());
        }

        public void visitBreakStatement(BreakStatementTree tree) {
            this.visitJumpStatement(tree.breakKeyword(), tree.label());
            super.visitBreakStatement(tree);
        }

        public void visitContinueStatement(ContinueStatementTree tree) {
            this.visitJumpStatement(tree.continueKeyword(), tree.label());
            super.visitContinueStatement(tree);
        }

        private void visitJumpStatement(SyntaxToken keyword, @Nullable IdentifierTree label) {
            if (label != null) {
                this.addComplexityWithoutNesting(keyword);
            }
        }

        private void visit(Tree ... trees) {
            for (Tree tree : trees) {
                if (tree == null) continue;
                tree.accept((DoubleDispatchVisitor)this);
            }
        }

        private void visitWithNesting(Tree tree) {
            ++this.nestingLevel;
            tree.accept((DoubleDispatchVisitor)this);
            --this.nestingLevel;
        }

        private void addComplexityWithNesting(SyntaxToken secondaryLocationToken) {
            if (this.functionStack.peek().equals(this.currentFunction)) {
                this.functionContainsStructuralComplexity = true;
            }
            this.addComplexity(this.nestingLevel + 1, secondaryLocationToken);
        }

        private void addComplexityWithoutNesting(SyntaxToken secondaryLocationToken) {
            this.addComplexity(1, secondaryLocationToken);
        }

        private void addComplexity(int addedComplexity, SyntaxToken secondaryLocationToken) {
            if (this.functionStack.peek().equals(this.currentFunction)) {
                this.ownComplexity += addedComplexity;
            } else {
                this.nestedFunctionComplexity += addedComplexity;
            }
            this.secondaryIssueLocations.add(new IssueLocation((Tree)secondaryLocationToken, CognitiveComplexity.secondaryMessage(addedComplexity)));
        }

        private static String secondaryMessage(int complexity) {
            if (complexity == 1) {
                return "+1";
            }
            return String.format("+%s (incl. %s for nesting)", complexity, complexity - 1);
        }

        public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
            this.visitFunction((FunctionTree)tree);
            super.visitFunctionDeclaration(tree);
            this.leaveFunction((FunctionTree)tree);
        }

        public void visitArrowFunction(ArrowFunctionTree tree) {
            this.visitFunction((FunctionTree)tree);
            super.visitArrowFunction(tree);
            this.leaveFunction((FunctionTree)tree);
        }

        public void visitFunctionExpression(FunctionExpressionTree tree) {
            this.visitFunction((FunctionTree)tree);
            super.visitFunctionExpression(tree);
            this.leaveFunction((FunctionTree)tree);
        }

        public void visitMethodDeclaration(MethodDeclarationTree tree) {
            this.visitFunction((FunctionTree)tree);
            super.visitMethodDeclaration(tree);
            this.leaveFunction((FunctionTree)tree);
        }

        private static boolean isElseIf(IfStatementTree tree) {
            return ((JavaScriptTree)tree).getParent().is(new Kinds[]{Tree.Kind.ELSE_CLAUSE});
        }
    }
}

