/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S878")
public class CommaOperatorUseCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE_ONE_COMMA = "Remove use of this comma operator.";
    private static final String MESSAGE_MANY_COMMAS = "Remove use of all comma operators in this expression.";

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (!tree.is(new Kinds[]{Tree.Kind.COMMA_OPERATOR})) {
            super.visitBinaryExpression(tree);
            return;
        }
        this.raiseIssue(tree);
        CommaOperatorUseCheck.getAllSubExpressions(tree).forEach(expression -> super.scan((Tree)expression));
    }

    private void raiseIssue(BinaryExpressionTree tree) {
        List<SyntaxToken> commas = CommaOperatorUseCheck.getCommas(tree);
        String message = commas.size() > 1 ? MESSAGE_MANY_COMMAS : MESSAGE_ONE_COMMA;
        PreciseIssue issue = this.addIssue((Tree)commas.get(0), message);
        commas.subList(1, commas.size()).forEach(arg_0 -> ((PreciseIssue)issue).secondary(arg_0));
    }

    public void visitForStatement(ForStatementTree tree) {
        this.visitPossibleException(tree.init());
        super.scan((Tree)tree.condition());
        this.visitPossibleException((Tree)tree.update());
        super.scan((Tree)tree.statement());
    }

    private void visitPossibleException(@Nullable Tree tree) {
        if (tree != null && tree.is(new Kinds[]{Tree.Kind.COMMA_OPERATOR})) {
            List<ExpressionTree> expressions = CommaOperatorUseCheck.getAllSubExpressions((BinaryExpressionTree)tree);
            for (ExpressionTree expression : expressions) {
                super.scan((Tree)expression);
            }
        } else {
            super.scan(tree);
        }
    }

    private static List<ExpressionTree> getAllSubExpressions(BinaryExpressionTree tree) {
        LinkedList<ExpressionTree> result = new LinkedList<ExpressionTree>();
        result.add(tree.rightOperand());
        ExpressionTree currentExpression = tree.leftOperand();
        while (currentExpression.is(new Kinds[]{Tree.Kind.COMMA_OPERATOR})) {
            result.add(((BinaryExpressionTree)currentExpression).rightOperand());
            currentExpression = ((BinaryExpressionTree)currentExpression).leftOperand();
        }
        result.add(currentExpression);
        return result;
    }

    private static List<SyntaxToken> getCommas(BinaryExpressionTree tree) {
        ArrayList<SyntaxToken> commas = new ArrayList<SyntaxToken>();
        commas.add(tree.operator());
        ExpressionTree currentExpression = tree.leftOperand();
        while (currentExpression.is(new Kinds[]{Tree.Kind.COMMA_OPERATOR})) {
            commas.add(((BinaryExpressionTree)currentExpression).operator());
            currentExpression = ((BinaryExpressionTree)currentExpression).leftOperand();
        }
        return Lists.reverse(commas);
    }
}

