/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="EmptyBlock")
public class EmptyBlockCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Either remove or fill this block of code.";

    public void visitBlock(BlockTree tree) {
        if (tree.statements().isEmpty() && !EmptyBlockCheck.hasComment(tree.closeCurlyBrace())) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitBlock(tree);
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.scan((Tree)tree.name());
        this.scan((Tree)tree.parameterClause());
        this.scan(tree.body().statements());
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.scan((Tree)tree.name());
        this.scan((Tree)tree.parameterClause());
        this.scan(tree.body().statements());
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.visitMethodDeclarationTree(tree);
    }

    private void visitMethodDeclarationTree(MethodDeclarationTree tree) {
        this.scan(tree.name());
        this.scan((Tree)tree.parameterClause());
        this.scan(tree.body().statements());
    }

    private static boolean hasComment(SyntaxToken closingBrace) {
        return !closingBrace.trivias().isEmpty();
    }
}

