/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S888")
public class EqualInForLoopTerminationCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Replace '%s' operator with one of '<=', '>=', '<', or '>' comparison operators.";

    public void visitForStatement(ForStatementTree tree) {
        boolean updateCondition;
        ExpressionTree condition = tree.condition();
        ExpressionTree update = tree.update();
        boolean conditionCondition = condition != null && EqualInForLoopTerminationCheck.isEquality(condition);
        boolean bl = updateCondition = update != null && EqualInForLoopTerminationCheck.isUpdateIncDec(update);
        if (conditionCondition && updateCondition && !EqualInForLoopTerminationCheck.isException(tree)) {
            this.addIssue((BinaryExpressionTree)condition);
        }
        super.visitForStatement(tree);
    }

    private static void counters(ExpressionTree update, Set<String> counters) {
        ExpressionTree counter = null;
        if (update.is(new Kinds[]{Tree.Kind.COMMA_OPERATOR})) {
            BinaryExpressionTree commaExpressions = (BinaryExpressionTree)update;
            EqualInForLoopTerminationCheck.counters(commaExpressions.leftOperand(), counters);
            EqualInForLoopTerminationCheck.counters(commaExpressions.rightOperand(), counters);
        } else if (update.is(new Kinds[]{KindSet.INC_DEC_KINDS})) {
            counter = ((UnaryExpressionTree)update).expression();
        } else if (update.is(new Kinds[]{Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT})) {
            counter = ((AssignmentExpressionTree)update).variable();
        }
        if (counter != null && counter.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            counters.add(((IdentifierTree)counter).name());
        }
    }

    private void addIssue(BinaryExpressionTree condition) {
        String message = String.format(MESSAGE, condition.operator().text());
        this.addIssue((Tree)condition.operator(), message);
    }

    private static boolean isEquality(ExpressionTree condition) {
        return condition.is(new Kinds[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO});
    }

    private static boolean isException(ForStatementTree forStatement) {
        return EqualInForLoopTerminationCheck.isNontrivialConditionException(forStatement) || EqualInForLoopTerminationCheck.isTrivialIteratorException(forStatement);
    }

    private static boolean isTrivialIteratorException(ForStatementTree forStatement) {
        ExpressionTree condition = forStatement.condition();
        if (condition != null && condition.is(new Kinds[]{Tree.Kind.NOT_EQUAL_TO})) {
            ExpressionTree update = forStatement.update();
            Tree init = forStatement.init();
            if (init != null && update != null) {
                return EqualInForLoopTerminationCheck.checkForTrivialIteratorException(init, condition, update);
            }
        }
        return false;
    }

    private static boolean checkForTrivialIteratorException(Tree init, ExpressionTree condition, ExpressionTree update) {
        int updateByOne = EqualInForLoopTerminationCheck.checkForUpdateByOne(update);
        if (updateByOne != 0) {
            Integer endValue = EqualInForLoopTerminationCheck.getValue((Tree)condition);
            Integer beginValue = EqualInForLoopTerminationCheck.getValue(init);
            if (endValue != null && beginValue != null && updateByOne == Integer.signum(endValue - beginValue)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isNontrivialConditionException(ForStatementTree forStatement) {
        ExpressionTree condition = forStatement.condition();
        ExpressionTree update = forStatement.update();
        if (update != null && condition != null && condition.is(new Kinds[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO})) {
            HashSet<String> counters = new HashSet<String>();
            EqualInForLoopTerminationCheck.counters(update, counters);
            ExpressionTree leftOperand = ((BinaryExpressionTree)condition).leftOperand();
            return !leftOperand.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) || !counters.contains(((IdentifierTree)leftOperand).name());
        }
        return false;
    }

    @Nullable
    private static Integer getValue(Tree tree) {
        Integer result = null;
        if (tree.is(new Kinds[]{Tree.Kind.NOT_EQUAL_TO})) {
            result = EqualInForLoopTerminationCheck.getInteger(((BinaryExpressionTree)tree).rightOperand());
        } else if (EqualInForLoopTerminationCheck.isOneVarDeclaration(tree)) {
            BindingElementTree variable = (BindingElementTree)((VariableDeclarationTree)tree).variables().get(0);
            if (variable.is(new Kinds[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) {
                result = EqualInForLoopTerminationCheck.getInteger(((InitializedBindingElementTree)variable).right());
            }
        } else if (tree.is(new Kinds[]{Tree.Kind.ASSIGNMENT})) {
            result = EqualInForLoopTerminationCheck.getInteger(((AssignmentExpressionTree)tree).expression());
        }
        return result;
    }

    private static boolean isOneVarDeclaration(Tree tree) {
        return tree.is(new Kinds[]{Tree.Kind.VAR_DECLARATION}) && ((VariableDeclarationTree)tree).variables().size() == 1;
    }

    private static Integer getInteger(ExpressionTree expression) {
        if (expression.is(new Kinds[]{Tree.Kind.NUMERIC_LITERAL})) {
            LiteralTree literal = (LiteralTree)expression;
            try {
                Integer decoded = Integer.decode(literal.value());
                return decoded;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private static int checkForUpdateByOne(ExpressionTree update) {
        if (update.is(new Kinds[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_INCREMENT}) || update.is(new Kinds[]{Tree.Kind.PLUS_ASSIGNMENT}) && EqualInForLoopTerminationCheck.isUpdateOnOneWithAssign(update)) {
            return 1;
        }
        if (update.is(new Kinds[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_DECREMENT}) || update.is(new Kinds[]{Tree.Kind.MINUS_ASSIGNMENT}) && EqualInForLoopTerminationCheck.isUpdateOnOneWithAssign(update)) {
            return -1;
        }
        return 0;
    }

    private static boolean isUpdateIncDec(ExpressionTree update) {
        boolean result = false;
        if (update.is(new Kinds[]{Tree.Kind.COMMA_OPERATOR})) {
            BinaryExpressionTree commaExpressions = (BinaryExpressionTree)update;
            result = EqualInForLoopTerminationCheck.isUpdateIncDec(commaExpressions.leftOperand()) && EqualInForLoopTerminationCheck.isUpdateIncDec(commaExpressions.rightOperand());
        } else if (update.is(new Kinds[]{KindSet.INC_DEC_KINDS}) || update.is(new Kinds[]{Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT})) {
            result = true;
        }
        return result;
    }

    private static boolean isUpdateOnOneWithAssign(ExpressionTree update) {
        if (update.is(new Kinds[]{Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT})) {
            ExpressionTree rightExpression = ((AssignmentExpressionTree)update).expression();
            return rightExpression.is(new Kinds[]{Tree.Kind.NUMERIC_LITERAL}) && "1".equals(((LiteralTree)rightExpression).value());
        }
        return false;
    }
}

