/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.FileIssue;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.JavaScriptFile;

@Rule(key="S1451")
public class FileHeaderCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Add or update the header of this file.";
    private static final String DEFAULT_HEADER_FORMAT = "";
    @RuleProperty(key="headerFormat", description="Expected copyright and license header", defaultValue="", type="TEXT")
    public String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    public boolean isRegularExpression = false;
    private String[] expectedLines = null;
    private Pattern searchPattern = null;

    public void visitScript(ScriptTree tree) {
        if (this.isRegularExpression) {
            this.checkRegularExpression();
        } else {
            this.checkPlainText();
        }
    }

    private void checkPlainText() {
        JavaScriptFile file;
        List<String> lines;
        if (this.expectedLines == null) {
            this.expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
        }
        if (!FileHeaderCheck.matches(this.expectedLines, lines = CheckUtils.readLines(file = this.getContext().getJavaScriptFile()))) {
            this.addIssue((Issue)new FileIssue((JavaScriptCheck)this, MESSAGE));
        }
    }

    private void checkRegularExpression() {
        String fileContent;
        Matcher matcher;
        if (this.searchPattern == null) {
            try {
                this.searchPattern = Pattern.compile(this.headerFormat, 32);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[" + ((Object)((Object)this)).getClass().getSimpleName() + "] Unable to compile the regular expression: " + this.headerFormat, e);
            }
        }
        if (!(matcher = this.searchPattern.matcher(fileContent = this.getContext().getJavaScriptFile().contents())).find() || matcher.start() != 0) {
            this.addIssue((Issue)new FileIssue((JavaScriptCheck)this, MESSAGE));
        }
    }

    private static boolean matches(String[] expectedLines, List<String> lines) {
        boolean result;
        if (expectedLines.length <= lines.size()) {
            result = true;
            Iterator<String> it = lines.iterator();
            for (String expectedLine : expectedLines) {
                String line = it.next();
                if (line.equals(expectedLine)) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }
}

