/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1994")
public class ForLoopConditionAndUpdateCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "This loop's stop condition tests \"%s\" but the incrementer updates \"%s\".";

    public void visitForStatement(ForStatementTree forStatement) {
        List<ExpressionTree> updatedExpressions = ForLoopConditionAndUpdateCheck.updatedExpressions(forStatement.update());
        ExpressionTree condition = forStatement.condition();
        if (!updatedExpressions.isEmpty() && condition != null) {
            ConditionVisitor conditionVisitor = new ConditionVisitor(updatedExpressions);
            condition.accept((DoubleDispatchVisitor)conditionVisitor);
            if (!conditionVisitor.foundUpdatedExpression) {
                String updated = ForLoopConditionAndUpdateCheck.expressionList(updatedExpressions);
                String tested = ForLoopConditionAndUpdateCheck.expressionList(conditionVisitor.testedExpressions);
                String message = String.format(MESSAGE, tested, updated);
                this.addIssue((Tree)forStatement.forKeyword(), message);
            }
        }
        super.visitForStatement(forStatement);
    }

    private static String expressionList(List<ExpressionTree> expressions) {
        ArrayList names = Lists.newArrayList();
        for (ExpressionTree expression : expressions) {
            names.add(CheckUtils.asString((Tree)expression));
        }
        return Joiner.on((String)", ").join((Iterable)names);
    }

    private static IdentifierTree callee(CallExpressionTree tree) {
        ExpressionTree callee = tree.callee();
        while (callee.is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            callee = ((MemberExpressionTree)callee).object();
        }
        if (callee.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && !callee.equals(tree.callee())) {
            return (IdentifierTree)callee;
        }
        return null;
    }

    private static List<ExpressionTree> updatedExpressions(@Nullable ExpressionTree expression) {
        if (expression == null) {
            return ImmutableList.of();
        }
        UpdateVisitor visitor = new UpdateVisitor();
        expression.accept((DoubleDispatchVisitor)visitor);
        return visitor.updatedExpressions;
    }

    private static class ConditionVisitor
    extends DoubleDispatchVisitorCheck {
        private List<ExpressionTree> updatedExpressions;
        private List<ExpressionTree> testedExpressions = Lists.newArrayList();
        private Deque<MemberExpressionTree> memberExpressions = new ArrayDeque<MemberExpressionTree>();
        private boolean foundUpdatedExpression = false;

        public ConditionVisitor(List<ExpressionTree> updatedExpressions) {
            this.updatedExpressions = updatedExpressions;
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.checkForUpdate((ExpressionTree)tree);
        }

        public void visitMemberExpression(MemberExpressionTree tree) {
            this.checkForUpdate((ExpressionTree)tree);
            this.memberExpressions.push(tree);
            super.visitMemberExpression(tree);
            this.memberExpressions.pop();
        }

        public void visitCallExpression(CallExpressionTree tree) {
            IdentifierTree callee = ForLoopConditionAndUpdateCheck.callee(tree);
            if (callee != null) {
                this.checkForUpdate((ExpressionTree)callee);
            } else {
                this.logTestedExpression(tree.callee());
            }
            this.scan((Tree)tree.arguments());
        }

        private void checkForUpdate(ExpressionTree tree) {
            this.logTestedExpression(tree);
            for (ExpressionTree updatedExpression : this.updatedExpressions) {
                if (!SyntacticEquivalence.areEquivalent((Tree)updatedExpression, (Tree)tree)) continue;
                this.foundUpdatedExpression = true;
            }
        }

        private void logTestedExpression(ExpressionTree tree) {
            if (this.memberExpressions.isEmpty()) {
                this.testedExpressions.add(tree);
            }
        }
    }

    private static class UpdateVisitor
    extends DoubleDispatchVisitorCheck {
        private final List<ExpressionTree> updatedExpressions = Lists.newArrayList();

        private UpdateVisitor() {
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.updatedExpressions.add(tree.variable());
            super.visitAssignmentExpression(tree);
        }

        public void visitUnaryExpression(UnaryExpressionTree tree) {
            if (tree.is(new Kinds[]{KindSet.INC_DEC_KINDS})) {
                this.updatedExpressions.add(tree.expression());
            }
            super.visitUnaryExpression(tree);
        }

        public void visitCallExpression(CallExpressionTree tree) {
            IdentifierTree callee = ForLoopConditionAndUpdateCheck.callee(tree);
            if (callee != null) {
                this.updatedExpressions.add((ExpressionTree)callee);
            }
            super.visitCallExpression(tree);
        }
    }
}

