/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1764")
public class IdenticalExpressionOnBinaryOperatorCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Correct one of the identical sub-expressions on both sides of operator \"%s\"";

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (!tree.is(new Kinds[]{Tree.Kind.MULTIPLY, Tree.Kind.PLUS, Tree.Kind.ASSIGNMENT}) && SyntacticEquivalence.areEquivalent((Tree)tree.leftOperand(), (Tree)tree.rightOperand()) && IdenticalExpressionOnBinaryOperatorCheck.isExcluded(tree)) {
            String message = String.format(MESSAGE, tree.operator().text());
            this.addIssue((Tree)tree.rightOperand(), message).secondary((Tree)tree.leftOperand());
        }
        super.visitBinaryExpression(tree);
    }

    private static boolean isExcluded(BinaryExpressionTree tree) {
        return !IdenticalExpressionOnBinaryOperatorCheck.isOneOntoOneShifting(tree) && !IdenticalExpressionOnBinaryOperatorCheck.isPotentialNanComparison(tree);
    }

    private static boolean isPotentialNanComparison(BinaryExpressionTree tree) {
        return tree.is(new Kinds[]{Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO}) && (tree.leftOperand().is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.BRACKET_MEMBER_EXPRESSION, Tree.Kind.DOT_MEMBER_EXPRESSION}) || tree.leftOperand() instanceof UnaryExpressionTree);
    }

    private static boolean isOneOntoOneShifting(BinaryExpressionTree tree) {
        return tree.is(new Kinds[]{Tree.Kind.LEFT_SHIFT}) && tree.leftOperand().is(new Kinds[]{Tree.Kind.NUMERIC_LITERAL}) && "1".equals(((LiteralTree)tree.leftOperand()).value());
    }
}

