/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="NonEmptyCaseWithoutBreak")
public class NonEmptyCaseWithoutBreakCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "End this switch case with an unconditional break, continue, return or throw statement.";

    public void visitSwitchStatement(SwitchStatementTree tree) {
        HashSet<Tree> caseExpressions = new HashSet<Tree>();
        CaseClauseTree lastCaseClause = null;
        for (CaseClauseTree caseClause : Iterables.filter((Iterable)tree.cases(), CaseClauseTree.class)) {
            NonEmptyCaseWithoutBreakCheck.addCaseExpression(caseExpressions, caseClause.expression());
            lastCaseClause = caseClause;
        }
        Map<CaseClauseTree, CfgBranchingBlock> caseClauseBlocksByTree = NonEmptyCaseWithoutBreakCheck.caseClauseBlocksByTree(tree);
        SwitchClauseTree previousClauseWithStatement = null;
        for (SwitchClauseTree switchClause : tree.cases()) {
            CfgBlock firstBlockInClauseBody;
            if (previousClauseWithStatement != null && (NonEmptyCaseWithoutBreakCheck.canBeFallenInto(switchClause, firstBlockInClauseBody = switchClause.is(new Kinds[]{Tree.Kind.CASE_CLAUSE}) ? caseClauseBlocksByTree.get(switchClause).trueSuccessor() : caseClauseBlocksByTree.get(lastCaseClause).falseSuccessor(), caseExpressions) || NonEmptyCaseWithoutBreakCheck.hasOnlyEmptyStatements(previousClauseWithStatement))) {
                this.addIssue((Tree)previousClauseWithStatement.keyword(), MESSAGE);
            }
            if (switchClause.statements().isEmpty()) continue;
            previousClauseWithStatement = switchClause;
        }
        super.visitSwitchStatement(tree);
    }

    private static Map<CaseClauseTree, CfgBranchingBlock> caseClauseBlocksByTree(SwitchStatementTree switchTree) {
        ControlFlowGraph cfg = CheckUtils.buildControlFlowGraph((Tree)switchTree);
        HashMap<CaseClauseTree, CfgBranchingBlock> map = new HashMap<CaseClauseTree, CfgBranchingBlock>();
        for (CfgBlock block : cfg.blocks()) {
            if (!(block instanceof CfgBranchingBlock)) continue;
            CfgBranchingBlock branchingBlock = (CfgBranchingBlock)block;
            Tree branchingTree = branchingBlock.branchingTree();
            if (!branchingTree.is(new Kinds[]{Tree.Kind.CASE_CLAUSE})) continue;
            map.put((CaseClauseTree)branchingTree, branchingBlock);
        }
        return map;
    }

    private static void addCaseExpression(Set<Tree> caseExpressions, ExpressionTree expression) {
        if (expression.is(new Kinds[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            NonEmptyCaseWithoutBreakCheck.addCaseExpression(caseExpressions, ((ParenthesisedExpressionTree)expression).expression());
        } else {
            caseExpressions.add((Tree)expression);
        }
    }

    private static boolean hasOnlyEmptyStatements(SwitchClauseTree switchClause) {
        return NonEmptyCaseWithoutBreakCheck.firstNonEmptyStatement(switchClause.statements()) == null;
    }

    private static boolean canBeFallenInto(SwitchClauseTree switchClause, CfgBlock caseBlock, Set<Tree> caseExpressions) {
        StatementTree firstNonEmptyStatement = NonEmptyCaseWithoutBreakCheck.firstNonEmptyStatement(switchClause.statements());
        if (firstNonEmptyStatement == null) {
            return false;
        }
        for (CfgBlock predecessor : caseBlock.predecessors()) {
            int predecessorIndex;
            int statementIndex;
            List predecessorElements = predecessor.elements();
            Tree predecessorLastElement = (Tree)predecessorElements.get(predecessorElements.size() - 1);
            if (caseExpressions.contains(predecessorLastElement) || (statementIndex = NonEmptyCaseWithoutBreakCheck.tokenIndex((Tree)firstNonEmptyStatement)) <= (predecessorIndex = NonEmptyCaseWithoutBreakCheck.tokenIndex((Tree)predecessorElements.get(0)))) continue;
            return true;
        }
        return false;
    }

    private static int tokenIndex(Tree tree) {
        JavaScriptTree jsTree = (JavaScriptTree)tree;
        InternalSyntaxToken firstToken = (InternalSyntaxToken)jsTree.getFirstToken();
        return firstToken.startIndex();
    }

    private static StatementTree firstNonEmptyStatement(List<StatementTree> statements) {
        for (StatementTree statement : statements) {
            if (statement.is(new Kinds[]{Tree.Kind.BLOCK})) {
                StatementTree nestedFirstStatement = NonEmptyCaseWithoutBreakCheck.firstNonEmptyStatement(((BlockTree)statement).statements());
                if (nestedFirstStatement == null) continue;
                return nestedFirstStatement;
            }
            if (statement.is(new Kinds[]{Tree.Kind.EMPTY_STATEMENT})) continue;
            return statement;
        }
        return null;
    }
}

