/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAnyPathSeCheck;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.Type;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.se.sv.SpecialSymbolicValue;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

@Rule(key="S3759")
public class NonExistentPropertyAccessCheck
extends AbstractAnyPathSeCheck {
    private static final String MESSAGE = "Remove this access to \"%s\" property, it doesn't exist, as a built-in, on %s.";
    private static final Map<Type, String> TYPE_NAMES = ImmutableMap.builder().put((Object)Type.NUMBER_PRIMITIVE, (Object)"Number").put((Object)Type.NUMBER_OBJECT, (Object)"Number").put((Object)Type.STRING_PRIMITIVE, (Object)"String").put((Object)Type.STRING_OBJECT, (Object)"String").put((Object)Type.BOOLEAN_PRIMITIVE, (Object)"Boolean").put((Object)Type.BOOLEAN_OBJECT, (Object)"Boolean").build();
    private ProgramState programStateBefore = null;

    public void beforeBlockElement(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        this.programStateBefore = currentState;
    }

    public void afterBlockElement(ProgramState currentState, Tree element) {
        if (NonExistentPropertyAccessCheck.isUndefinedProperty(currentState, element) && !NonExistentPropertyAccessCheck.isWrite(element) && !NonExistentPropertyAccessCheck.isInCondition(element)) {
            IdentifierTree propertyTree = ((DotMemberExpressionTree)element).property();
            this.addUniqueIssue(element, String.format(MESSAGE, propertyTree.name(), NonExistentPropertyAccessCheck.getTypeOfObject(this.programStateBefore)));
        }
    }

    private static String getTypeOfObject(ProgramState programState) {
        Constraint constraintOnObject = programState.getConstraint(programState.peekStack());
        Type type = Type.find((Constraint)constraintOnObject);
        return TYPE_NAMES.containsKey(type) ? "a " + TYPE_NAMES.get(type) : "this object";
    }

    private static boolean isUndefinedProperty(ProgramState currentState, Tree element) {
        return element.is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && SpecialSymbolicValue.UNDEFINED.equals((Object)currentState.peekStack());
    }

    private static boolean isWrite(Tree element) {
        JavaScriptTree parentTree = ((JavaScriptTree)element).getParent();
        return parentTree.is(new Kinds[]{Tree.Kind.ASSIGNMENT}) && !((AssignmentExpressionTree)parentTree).expression().equals(element);
    }

    private static boolean isInCondition(Tree element) {
        JavaScriptTree parentTree = ((JavaScriptTree)element).getParent();
        return parentTree.is(new Kinds[]{Tree.Kind.IF_STATEMENT, Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.CONDITIONAL_EXPRESSION});
    }
}

