/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.symbols.type.ObjectType;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S2762")
public class NotStoredSelectionCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Selection \"$( %s )\" is made %s times. It should be stored in a variable and reused.";
    private static final int DEFAULT = 2;
    @RuleProperty(key="threshold", description="Number of allowed repetition before triggering an issue", defaultValue="2")
    public int threshold = 2;
    private Deque<ListMultimap<String, CallExpressionTree>> selectors;

    public void visitScript(ScriptTree tree) {
        this.selectors = new ArrayDeque<ListMultimap<String, CallExpressionTree>>();
        this.startScopeBlock();
        super.visitScript(tree);
        this.finishScopeBlock();
    }

    private void finishScopeBlock() {
        this.checkForDuplications(this.selectors.pop());
    }

    private void checkForDuplications(ListMultimap<String, CallExpressionTree> selectors) {
        for (String selectorText : selectors.keySet()) {
            List references = selectors.get((Object)selectorText);
            int numberOfDuplications = references.size();
            if (numberOfDuplications <= this.threshold) continue;
            String message = String.format(MESSAGE, selectorText, numberOfDuplications);
            PreciseIssue issue = this.addIssue((Tree)references.get(0), message).cost((double)numberOfDuplications - (double)this.threshold);
            references.subList(1, references.size()).forEach(arg_0 -> ((PreciseIssue)issue).secondary(arg_0));
        }
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.startScopeBlock();
        super.visitFunctionDeclaration(tree);
        this.finishScopeBlock();
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.startScopeBlock();
        super.visitFunctionExpression(tree);
        this.finishScopeBlock();
    }

    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.startScopeBlock();
        super.visitArrowFunction(tree);
        this.finishScopeBlock();
    }

    private void startScopeBlock() {
        this.selectors.push((ListMultimap<String, CallExpressionTree>)ArrayListMultimap.create());
    }

    public void visitCallExpression(CallExpressionTree tree) {
        LiteralTree parameter;
        if (tree.types().contains((Object)ObjectType.FrameworkType.JQUERY_SELECTOR_OBJECT) && (parameter = NotStoredSelectionCheck.getSelectorParameter(tree)) != null) {
            String value = parameter.value();
            this.selectors.peek().put((Object)value, (Object)tree);
        }
        super.visitCallExpression(tree);
    }

    private static LiteralTree getSelectorParameter(CallExpressionTree tree) {
        SeparatedList parameters = tree.arguments().parameters();
        if (parameters.size() == 1 && ((Tree)parameters.get(0)).is(new Kinds[]{Tree.Kind.STRING_LITERAL}) && !NotStoredSelectionCheck.isElementCreation((LiteralTree)parameters.get(0))) {
            return (LiteralTree)parameters.get(0);
        }
        return null;
    }

    private static boolean isElementCreation(LiteralTree literalTree) {
        Preconditions.checkArgument((boolean)literalTree.is(new Kinds[]{Tree.Kind.STRING_LITERAL}));
        String value = literalTree.value();
        value = value.substring(1, value.length() - 1);
        return value.startsWith("<") && value.endsWith(">");
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        this.lookForException(tree.expression());
    }

    public void visitInitializedBindingElement(InitializedBindingElementTree tree) {
        super.visitInitializedBindingElement(tree);
        this.lookForException(tree.right());
    }

    private void lookForException(ExpressionTree tree) {
        LiteralTree parameter;
        CallExpressionTree callExpressionTree;
        if (tree.is(new Kinds[]{Tree.Kind.CALL_EXPRESSION}) && (callExpressionTree = (CallExpressionTree)tree).types().contains((Object)ObjectType.FrameworkType.JQUERY_SELECTOR_OBJECT) && (parameter = NotStoredSelectionCheck.getSelectorParameter(callExpressionTree)) != null) {
            this.selectors.peek().remove((Object)parameter.value(), (Object)tree);
        }
    }
}

