/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAllPathSeCheck;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;

@Rule(key="S3003")
public class StringsComparisonCheck
extends AbstractAllPathSeCheck<BinaryExpressionTree> {
    private static final String MESSAGE = "Convert operands of this use of \"%s\" to number type.";
    private static final Tree.Kind[] RELATIVE_OPERATIONS = new Tree.Kind[]{Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO};

    @Override
    BinaryExpressionTree getTree(Tree element) {
        if (element.is((Kinds[])RELATIVE_OPERATIONS)) {
            return (BinaryExpressionTree)element;
        }
        return null;
    }

    @Override
    boolean isProblem(BinaryExpressionTree tree, ProgramState currentState) {
        Constraint rightConstraint = currentState.getConstraint(currentState.peekStack(0));
        Constraint leftConstraint = currentState.getConstraint(currentState.peekStack(1));
        return rightConstraint.isStricterOrEqualTo(Constraint.ANY_STRING) && leftConstraint.isStricterOrEqualTo(Constraint.ANY_STRING);
    }

    @Override
    void raiseIssue(BinaryExpressionTree tree) {
        if (!StringsComparisonCheck.hasOneSymbolLiteralOperand(tree)) {
            String message = String.format(MESSAGE, tree.operator().text());
            this.addIssue((Tree)tree.operator(), message).secondary((Tree)tree.leftOperand()).secondary((Tree)tree.rightOperand());
        }
    }

    private static boolean hasOneSymbolLiteralOperand(BinaryExpressionTree expression) {
        LiteralTree literal = null;
        if (expression.leftOperand().is(new Kinds[]{Tree.Kind.STRING_LITERAL})) {
            literal = (LiteralTree)expression.leftOperand();
        } else if (expression.rightOperand().is(new Kinds[]{Tree.Kind.STRING_LITERAL})) {
            literal = (LiteralTree)expression.rightOperand();
        }
        return literal != null && literal.value().length() == 3;
    }
}

