/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S2123")
public class UselessIncrementCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this %s or correct the code not to waste it.";

    public void visitAssignmentExpression(AssignmentExpressionTree assignment) {
        if (assignment.expression().is(new Kinds[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT})) {
            UnaryExpressionTree postfix = (UnaryExpressionTree)assignment.expression();
            if (SyntacticEquivalence.areEquivalent((Tree)assignment.variable(), (Tree)postfix.expression())) {
                String type = postfix.is(new Kinds[]{Tree.Kind.POSTFIX_INCREMENT}) ? "increment" : "decrement";
                String message = String.format(MESSAGE, type);
                this.addIssue((Tree)postfix.operator(), message);
            }
        }
        super.visitAssignmentExpression(assignment);
    }
}

