/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="ExcessiveParameterList", name="Functions should not have too many parameters", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="20min")
public class ExcessiveParameterListCheck
extends BaseTreeVisitor {
    private static final int DEFAULT_MAXIMUM_FUNCTION_PARAMETERS = 7;
    @RuleProperty(key="maximumFunctionParameters", description="The maximum authorized number of parameters", defaultValue="7")
    private int maximumFunctionParameters = 7;

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkNumberOfParameters(tree.parameters());
        super.visitMethodDeclaration(tree);
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkNumberOfParameters(tree.parameters());
        super.visitFunctionDeclaration(tree);
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.checkNumberOfParameters(tree.parameters());
        super.visitFunctionExpression(tree);
    }

    private void checkNumberOfParameters(ParameterListTree tree) {
        Integer numberOfParameters = tree.parameters().size();
        if (numberOfParameters > this.maximumFunctionParameters) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree.parameters().get(0), "Function has " + numberOfParameters + " parameters which is greater than " + this.maximumFunctionParameters + " authorized.");
        }
    }

    public void setMaximumFunctionParameters(int threshold) {
        this.maximumFunctionParameters = threshold;
    }
}

