/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.visitors.CharsetAwareVisitor;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;
import org.sonar.squidbridge.annotations.NoSqale;

@Rule(key="S1451", name="Copyright and license headers should be defined", priority=Priority.BLOCKER)
@NoSqale
public class FileHeaderCheck
extends BaseTreeVisitor
implements CharsetAwareVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(FileHeaderCheck.class);
    private static final String DEFAULT_HEADER_FORMAT = "";
    @RuleProperty(key="headerFormat", type="TEXT", description="Expected copyright and license header (plain text)", defaultValue="")
    public String headerFormat = "";
    private Charset charset;
    private String[] expectedLines;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void scanFile(TreeVisitorContext context) {
        this.expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
        List lines = Collections.emptyList();
        try {
            lines = Files.readLines((File)context.getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            LOG.error("Unable to execute rule \"TabCharacter\" for file {} because of error: {}", (Object)context.getFile().getName(), (Object)e);
        }
        if (!FileHeaderCheck.matches(this.expectedLines, lines)) {
            context.addFileIssue((JavaScriptCheck)this, "Add or update the header of this file.");
        }
    }

    private static boolean matches(String[] expectedLines, List<String> lines) {
        boolean result;
        if (expectedLines.length <= lines.size()) {
            result = true;
            Iterator<String> it = lines.iterator();
            for (int i = 0; i < expectedLines.length; ++i) {
                String line = it.next();
                if (line.equals(expectedLines[i])) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }
}

