/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="FunctionComplexity", name="Functions should not be too complex", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="1h")
public class FunctionComplexityCheck
extends SubscriptionBaseTreeVisitor {
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 10;
    @RuleProperty(key="maximumFunctionComplexityThreshold", description="The maximum authorized complexity in function", defaultValue="10")
    private int maximumFunctionComplexityThreshold = 10;
    private boolean immediatelyInvokedFunctionExpression = false;
    private boolean amdPattern = false;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.FUNCTION_DECLARATION, (Object)Tree.Kind.FUNCTION_EXPRESSION, (Object)Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, (Object)Tree.Kind.GENERATOR_DECLARATION, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.GENERATOR_METHOD, (Object)Tree.Kind.CALL_EXPRESSION, (Object)Tree.Kind.NEW_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION})) {
            this.checkForImmediatelyInvokedFunction(((CallExpressionTree)tree).callee());
            this.checkForAMDPattern((CallExpressionTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_EXPRESSION})) {
            if (((NewExpressionTree)tree).arguments() != null) {
                this.checkForImmediatelyInvokedFunction(((NewExpressionTree)tree).expression());
            }
        } else {
            this.visitFunction(tree);
        }
    }

    private void visitFunction(Tree tree) {
        if (this.immediatelyInvokedFunctionExpression || this.amdPattern) {
            this.clearCheckState();
        } else {
            int complexity = this.getContext().getComplexity(tree);
            if (complexity > this.maximumFunctionComplexityThreshold) {
                String message = String.format("Function has a complexity of %s which is greater than %s authorized.", complexity, this.maximumFunctionComplexityThreshold);
                this.addIssue(tree, message);
            }
        }
    }

    public void setMaximumFunctionComplexityThreshold(int threshold) {
        this.maximumFunctionComplexityThreshold = threshold;
    }

    private void checkForImmediatelyInvokedFunction(ExpressionTree callee) {
        boolean parenthesisedFunctionCallee;
        Tree.Kind[] funcExprKinds = new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION};
        boolean directFunctionCallee = callee.is(funcExprKinds);
        boolean bl = parenthesisedFunctionCallee = callee.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && ((ParenthesisedExpressionTree)callee).expression().is(funcExprKinds);
        if (directFunctionCallee || parenthesisedFunctionCallee) {
            this.immediatelyInvokedFunctionExpression = true;
        }
    }

    private void checkForAMDPattern(CallExpressionTree tree) {
        if (tree.callee().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "define".equals(((IdentifierTree)tree.callee()).name())) {
            for (Tree parameter : tree.arguments().parameters()) {
                if (!parameter.is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION})) continue;
                this.amdPattern = true;
            }
        }
    }

    private void clearCheckState() {
        this.immediatelyInvokedFunctionExpression = false;
        this.amdPattern = false;
    }
}

