/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractJQuerySelectorOptimizationCheck;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2715", name="\"find\" should be used to select the children of an element known by id", priority=Priority.MAJOR, tags={"jquery", "performance", "user-experience"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class IdChildrenSelectorCheck
extends AbstractJQuerySelectorOptimizationCheck {
    private static final String MESSAGE = "Move \"%s\" into \"find\" method.";
    private static final Pattern idChildrenSelectorPattern = Pattern.compile("(#[\\w_-]+)[ ]+([^ ]+)");

    @Override
    protected void visitSelector(String selector, CallExpressionTree tree) {
        Matcher matcher = idChildrenSelectorPattern.matcher(selector);
        if (matcher.matches()) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, String.format(MESSAGE, matcher.group(2)));
        }
    }
}

