/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2713", name="JQuery cache variables should comply with a convention name", priority=Priority.MINOR, tags={"jquery", "convention"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class JQueryVarNameConventionCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Rename variable \"%s\" to match the regular expression %s.";
    private static final String DEFAULT_FORMAT = "^\\$[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the variable names against", defaultValue="^\\$[a-z][a-zA-Z0-9]*$")
    private String format = "^\\$[a-z][a-zA-Z0-9]*$";

    public void setFormat(String format) {
        this.format = format;
    }

    public void visitScript(ScriptTree tree) {
        Pattern pattern = Pattern.compile(this.format);
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        for (Symbol symbol : symbolModel.getSymbols(Symbol.Kind.VARIABLE)) {
            boolean onlyJQuerySelectorType = symbol.types().containsOnly(Type.Kind.JQUERY_SELECTOR_OBJECT);
            if (symbol.builtIn() || !onlyJQuerySelectorType || pattern.matcher(symbol.name()).matches()) continue;
            this.raiseIssuesOnDeclarations((JavaScriptCheck)this, symbol, String.format(MESSAGE, symbol.name(), this.format));
        }
    }

    protected void raiseIssuesOnDeclarations(JavaScriptCheck check, Symbol symbol, String message) {
        Preconditions.checkArgument((!symbol.builtIn() ? 1 : 0) != 0);
        boolean issueRaised = false;
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration()) continue;
            this.getContext().addIssue(check, (Tree)usage.identifierTree(), message);
            issueRaised = true;
        }
        if (!issueRaised) {
            this.getContext().addIssue(check, (Tree)((Usage)symbol.usages().iterator().next()).identifierTree(), message);
        }
    }
}

