/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2427", name="The base should be provided to \"parseInt\"", priority=Priority.CRITICAL, tags={"bug"})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class ParseIntCallWithoutBaseCheck
extends BaseTreeVisitor {
    public void visitCallExpression(CallExpressionTree tree) {
        if (ParseIntCallWithoutBaseCheck.isParseIntCall(tree.callee()) && tree.arguments().parameters().size() == 1) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, "Add the base to this \"parseInt\" call.");
        }
        super.visitCallExpression(tree);
    }

    private static boolean isParseIntCall(ExpressionTree callee) {
        return callee.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "parseInt".equals(((IdentifierTree)callee).name());
    }
}

