/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="PrimitiveWrappers", name="Wrapper objects should not be used for primitive types", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="1min")
public class PrimitiveWrappersCheck
extends BaseTreeVisitor {
    private static final Set<String> WRAPPERS = ImmutableSet.of((Object)"Boolean", (Object)"Number", (Object)"String");

    public void visitNewExpression(NewExpressionTree tree) {
        if (WRAPPERS.contains(CheckUtils.asString((Tree)tree.expression()))) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree.expression(), "Do not use wrapper objects for primitive types.");
        }
        super.visitNewExpression(tree);
    }
}

