/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2769", name="Selection results should be tested with \"length\"", priority=Priority.CRITICAL, tags={"bug", "jquery"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class SelectionTestedWithoutLengthCheck
extends BaseTreeVisitor {
    public void visitIfStatement(IfStatementTree tree) {
        ExpressionTree condition = tree.condition();
        if (condition.types().containsOnly(Type.Kind.JQUERY_SELECTOR_OBJECT)) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)condition, "Use the \"length\" property to see whether this selection contains elements.");
        }
        super.visitIfStatement(tree);
    }
}

