/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IterationStatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="UnreachableCode", name="Jump statements should not be followed by other statements", priority=Priority.MAJOR, tags={"cert", "cwe", "misra", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5 min")
public class UnreachableCodeCheck
extends SubscriptionBaseTreeVisitor {
    private Deque<Boolean> blockLevel = new ArrayDeque<Boolean>();
    private static final Tree.Kind[] JUMP_STATEMENTS = new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.THROW_STATEMENT};
    private static final Tree.Kind[] STATEMENTS = new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.IF_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.WITH_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.DEBUGGER_STATEMENT, Tree.Kind.VARIABLE_STATEMENT};

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object[])JUMP_STATEMENTS).add((Object[])STATEMENTS).add((Object[])new Tree.Kind[]{Tree.Kind.BLOCK, Tree.Kind.CASE_CLAUSE, Tree.Kind.DEFAULT_CLAUSE, Tree.Kind.ELSE_CLAUSE}).build();
    }

    public void visitFile(Tree scriptTree) {
        this.blockLevel.clear();
        this.enterBlock();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK}) || UnreachableCodeCheck.isScopeWithoutBlock(tree)) {
            this.enterBlock();
        } else if (!UnreachableCodeCheck.isExcludedExpression(tree) && this.isPrecededByAJump().booleanValue()) {
            this.getContext().addIssue((JavaScriptCheck)this, tree, "This statement can't be reached and so start a dead code block.");
            this.updateStateTo(false);
        }
        if (tree.is(JUMP_STATEMENTS)) {
            this.updateStateTo(true);
        }
    }

    private static boolean isScopeWithoutBlock(Tree tree) {
        if (tree.is(CheckUtils.iterationStatementsArray())) {
            return !((IterationStatementTree)tree).statement().is(new Tree.Kind[]{Tree.Kind.BLOCK});
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            return !((IfStatementTree)tree).statement().is(new Tree.Kind[]{Tree.Kind.BLOCK});
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.ELSE_CLAUSE})) {
            return !((ElseClauseTree)tree).statement().is(new Tree.Kind[]{Tree.Kind.BLOCK});
        }
        return tree.is(new Tree.Kind[]{Tree.Kind.CASE_CLAUSE, Tree.Kind.DEFAULT_CLAUSE});
    }

    private static boolean isExcludedExpression(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.ELSE_CLAUSE}) || tree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) && ((ExpressionStatementTree)tree).expression().is(new Tree.Kind[]{Tree.Kind.CLASS_EXPRESSION});
    }

    private void updateStateTo(Boolean state) {
        this.blockLevel.pop();
        this.blockLevel.push(state);
    }

    private Boolean isPrecededByAJump() {
        return this.blockLevel.peek();
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK}) || UnreachableCodeCheck.isScopeWithoutBlock(tree)) {
            this.exitBlock();
        }
    }

    private void enterBlock() {
        this.blockLevel.push(false);
    }

    private void exitBlock() {
        this.blockLevel.pop();
    }
}

