/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collections;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1442", name="\"alert(...)\" should not be used", priority=Priority.MAJOR, tags={"cwe", "security", "user-experience"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="10min")
public class AlertUseCheck
extends BaseTreeVisitor {
    public void visitCallExpression(CallExpressionTree tree) {
        ExpressionTree callee = tree.callee();
        if (callee.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && AlertUseCheck.isAlertCall((IdentifierTree)callee)) {
            this.getContext().addIssue((JavaScriptCheck)this, new IssueLocation((Tree)tree, "Remove this usage of alert(...)."), Collections.emptyList(), null);
        }
        super.visitCallExpression(tree);
    }

    public static boolean isAlertCall(IdentifierTree identifier) {
        return "alert".equals(identifier.name());
    }
}

