/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="ConstructorFunctionsForSideEffects", name="Constructor functions should not be called purely for side-effects", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class ConstructorFunctionsForSideEffectsCheck
extends BaseTreeVisitor {
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        if (tree.expression().is(new Tree.Kind[]{Tree.Kind.NEW_EXPRESSION})) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, "Replace by a standard call to the function.");
        }
        super.visitExpressionStatement(tree);
    }
}

