/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.javascript.tree.impl.declaration.ParameterListTreeImpl;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="DuplicateFunctionArgument", name="Function argument names should be unique", priority=Priority.CRITICAL, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class DuplicateFunctionArgumentCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Rename or remove duplicate function argument '%s'.";

    public void visitParameterList(ParameterListTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
            HashSet values = Sets.newHashSet();
            for (IdentifierTree identifier : ((ParameterListTreeImpl)tree).parameterIdentifiers()) {
                this.checkIdentifier(identifier, identifier.name(), values);
            }
        }
        super.visitParameterList(tree);
    }

    private void checkIdentifier(IdentifierTree identifier, String value, Set<String> values) {
        String unescaped = EscapeUtils.unescape(value);
        if (values.contains(unescaped)) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)identifier, String.format(MESSAGE, value));
        } else {
            values.add(unescaped);
        }
    }
}

