/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="DuplicatePropertyName", name="Property names should not be duplicated within an object literal", priority=Priority.CRITICAL, tags={"bug", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class DuplicatePropertyNameCheck
extends BaseTreeVisitor {
    public void visitObjectLiteral(ObjectLiteralTree tree) {
        HashSet keys = Sets.newHashSet();
        for (Tree property : tree.properties()) {
            if (property.is(new Tree.Kind[]{Tree.Kind.PAIR_PROPERTY})) {
                this.visitPairProperty(keys, property, (PairPropertyTree)property);
            }
            if (!(property instanceof IdentifierTree)) continue;
            IdentifierTree identifier = (IdentifierTree)property;
            this.addKey(keys, identifier.name(), property);
        }
        super.visitObjectLiteral(tree);
    }

    private void visitPairProperty(Set<String> keys, Tree property, PairPropertyTree pairProperty) {
        ExpressionTree key = pairProperty.key();
        if (key.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String value = ((LiteralTree)key).value();
            value = value.substring(1, value.length() - 1);
            this.addKey(keys, value, property);
        }
        if (key instanceof IdentifierTree) {
            this.addKey(keys, ((IdentifierTree)key).name(), property);
        }
        if (key.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL})) {
            this.addKey(keys, ((LiteralTree)key).value(), property);
        }
    }

    private void addKey(Set<String> keys, String key, Tree property) {
        if (keys.contains(EscapeUtils.unescape(key))) {
            this.getContext().addIssue((JavaScriptCheck)this, property, "Rename or remove duplicate property name '" + key + "'.");
        } else {
            keys.add(key);
        }
    }
}

