/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractJQuerySelectorOptimizationCheck;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2898", name="\"[type=...]\" should be used to select elements by type", priority=Priority.MAJOR, tags={"jquery", "performance"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="2min")
public class ElementTypeSelectorCheck
extends AbstractJQuerySelectorOptimizationCheck {
    private static final String MESSAGE = "Use the \"[type='%s']\" selector here instead of \":%s\".";
    private static final Pattern elementUsedWithClassSelectorPattern = Pattern.compile(":(radio|checkbox|file|image|password|reset|text)", 2);

    @Override
    protected void visitSelector(String selector, CallExpressionTree tree) {
        Matcher matcher = elementUsedWithClassSelectorPattern.matcher(selector);
        if (matcher.find()) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, String.format(MESSAGE, matcher.group(1), matcher.group(1)));
        }
    }
}

