/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3271", name="Local storage should not be used", priority=Priority.CRITICAL, tags={"security", "owasp-a6"})
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleLinearWithOffsetRemediation(coeff="5min", offset="1h", effortToFixDescription="per additional use of the api")
public class LocalStorageCheck
extends BaseTreeVisitor {
    private static final List<String> API_CALLS = ImmutableList.of((Object)"getItem", (Object)"setItem", (Object)"removeItem", (Object)"clear", (Object)"key", (Object)"length");
    private static final List<String> OBJECTS = ImmutableList.of((Object)"localStorage", (Object)"sessionStorage");
    Map<String, StorageType> storageTypes = new HashedMap();

    public void visitScript(ScriptTree tree) {
        this.storageTypes.clear();
        super.visitScript(tree);
        this.checkForIssues();
    }

    public void visitMemberExpression(MemberExpressionTree tree) {
        String obj;
        if (tree.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            DotMemberExpressionTree dme = (DotMemberExpressionTree)tree;
            String obj2 = LocalStorageCheck.getObjectName((MemberExpressionTree)dme);
            String method = dme.property().name();
            if (OBJECTS.contains(obj2) && API_CALLS.contains(method)) {
                this.saveDebtLocation(tree, obj2);
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.BRACKET_MEMBER_EXPRESSION}) && OBJECTS.contains(obj = LocalStorageCheck.getObjectName(tree))) {
            this.saveDebtLocation(tree, obj);
        }
        super.visitMemberExpression(tree);
    }

    private void saveDebtLocation(MemberExpressionTree tree, String obj) {
        StorageType type = this.storageTypes.get(obj);
        if (type == null) {
            this.storageTypes.put(obj, new StorageType(tree));
        } else {
            type.inc();
        }
    }

    private static String getObjectName(MemberExpressionTree dme) {
        if (dme.object().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            DotMemberExpressionTree d2 = (DotMemberExpressionTree)dme.object();
            return d2.property().name();
        }
        return CheckUtils.asString((Tree)dme.object());
    }

    private void checkForIssues() {
        for (Map.Entry<String, StorageType> entry : this.storageTypes.entrySet()) {
            int cost = entry.getValue().count - 1;
            String message = String.format("Remove all use of \"%s\"; use cookies or store the data on the server instead.", entry.getKey());
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)entry.getValue().tree, message, (double)cost);
        }
    }

    private static class StorageType {
        private MemberExpressionTree tree;
        private int count;

        StorageType(MemberExpressionTree tree) {
            this.tree = tree;
            this.count = 1;
        }

        void inc() {
            ++this.count;
        }
    }
}

