/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collections;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="NamedFunctionExpression", name="Named function expressions should not be used", priority=Priority.MAJOR, tags={"cross-browser", "user-experience"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LANGUAGE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="15min")
public class NamedFunctionExpressionCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Make this function anonymous by removing its name: 'function() {...}'.";

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        if (tree.name() != null) {
            this.getContext().addIssue((JavaScriptCheck)this, new IssueLocation((Tree)tree.name(), MESSAGE), Collections.emptyList(), null);
        }
        super.visitFunctionExpression(tree);
    }
}

