/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.LabelledStatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1219", name="\"switch\" statements should not contain non-case labels", priority=Priority.CRITICAL, tags={"misra", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="10min")
public class NonCaseLabelInSwitchCheck
extends SubscriptionBaseTreeVisitor {
    private Deque<Integer> stack = new ArrayDeque<Integer>();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object[])new Tree.Kind[]{Tree.Kind.LABELLED_STATEMENT, Tree.Kind.CASE_CLAUSE}).add((Object[])new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_DECLARATION}).build();
    }

    public void visitFile(Tree scriptTree) {
        this.stack.clear();
        this.stack.push(0);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CASE_CLAUSE})) {
            this.enterCase();
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.LABELLED_STATEMENT})) {
            if (this.inCase()) {
                this.getContext().addIssue((JavaScriptCheck)this, tree, String.format("Remove this misleading \"%s\" label.", ((LabelledStatementTree)tree).label().name()));
            }
        } else {
            this.stack.push(0);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CASE_CLAUSE})) {
            this.leaveCase();
        } else if (!tree.is(new Tree.Kind[]{Tree.Kind.LABELLED_STATEMENT})) {
            this.stack.pop();
        }
    }

    private void leaveCase() {
        this.stack.push(this.stack.pop() - 1);
    }

    private boolean inCase() {
        return this.stack.peek() > 0;
    }

    private void enterCase() {
        this.stack.push(this.stack.pop() + 1);
    }
}

