/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="TrailingComma", name="Trailing commas should not be used", priority=Priority.BLOCKER, tags={"cross-browser"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="1min")
public class TrailingCommaCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Avoid trailing comma in array and object literals.";

    public void visitObjectLiteral(ObjectLiteralTree tree) {
        SeparatedList separatedList = tree.properties();
        int listSize = separatedList.size();
        if (listSize > 0 && listSize == separatedList.getSeparators().size()) {
            InternalSyntaxToken trailingComma = separatedList.getSeparator(listSize - 1);
            this.raiseIssue((Tree)trailingComma);
        }
        super.visitObjectLiteral(tree);
    }

    public void visitArrayLiteral(ArrayLiteralTree tree) {
        List elementsAndCommas = tree.elementsAndCommas();
        if (!elementsAndCommas.isEmpty()) {
            Tree last = (Tree)elementsAndCommas.get(elementsAndCommas.size() - 1);
            if (last.is(new Tree.Kind[]{Tree.Kind.TOKEN})) {
                this.raiseIssue(last);
            }
        }
        super.visitArrayLiteral(tree);
    }

    private void raiseIssue(Tree trailingComma) {
        this.getContext().addIssue((JavaScriptCheck)this, new IssueLocation(trailingComma, MESSAGE), (List)ImmutableList.of(), null);
    }
}

