/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="TrailingComment", name="Comments should not be located at the end of lines of code", priority=Priority.INFO, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class TrailingCommentCheck
extends SubscriptionBaseTreeVisitor {
    private static final String DEFAULT_LEGAL_COMMENT_PATTERN = "^//\\s*+[^\\s]++$";
    @RuleProperty(key="legalCommentPattern", description="Pattern for text of trailing comments that are allowed.", defaultValue="^//\\s*+[^\\s]++$")
    private String legalCommentPattern = "^//\\s*+[^\\s]++$";
    private Pattern pattern;
    private int previousTokenLine;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }

    public void visitFile(Tree tree) {
        this.previousTokenLine = -1;
        this.pattern = Pattern.compile(this.legalCommentPattern);
    }

    public void visitNode(Tree tree) {
        SyntaxToken token = (SyntaxToken)tree;
        for (SyntaxTrivia trivia : token.trivias()) {
            String comment;
            if (trivia.line() != this.previousTokenLine || !(comment = trivia.text()).startsWith("//") || this.pattern.matcher(comment).matches()) continue;
            this.getContext().addIssue((JavaScriptCheck)this, this.previousTokenLine, "Move this trailing comment on the previous empty line.");
        }
        this.previousTokenLine = token.line();
    }

    public void setLegalCommentPattern(String pattern) {
        this.legalCommentPattern = pattern;
    }
}

