/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collection;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="UnusedVariable", name="Unused local variables should be removed", priority=Priority.MAJOR, tags={"unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedVariableCheck
extends BaseTreeVisitor {
    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        for (Symbol variable : symbolModel.getSymbols(Symbol.Kind.VARIABLE)) {
            Collection usages = variable.usages();
            if (!UnusedVariableCheck.noUsages(usages) || UnusedVariableCheck.isGlobalOrCatchVariable(variable) || variable.builtIn()) continue;
            this.raiseIssuesOnDeclarations(variable, "Remove the declaration of the unused '" + variable.name() + "' variable.");
        }
    }

    private void raiseIssuesOnDeclarations(Symbol symbol, String message) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration()) continue;
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)usage.identifierTree(), message);
        }
    }

    private static boolean noUsages(Collection<Usage> usages) {
        return usages.isEmpty() || UnusedVariableCheck.usagesAreInitializations(usages);
    }

    private static boolean usagesAreInitializations(Collection<Usage> usages) {
        for (Usage usage : usages) {
            if (usage.isDeclaration()) continue;
            return false;
        }
        return true;
    }

    private static boolean isGlobalOrCatchVariable(Symbol symbol) {
        return symbol.scope().tree().is(new Tree.Kind[]{Tree.Kind.SCRIPT, Tree.Kind.CATCH_BLOCK});
    }
}

