/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collection;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="VariableShadowing", name="Variables should not be shadowed", priority=Priority.MAJOR, tags={"pitfall"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
public class VariableShadowingCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "\"%s\" hides or potentially hides a variable declared in an outer scope at line %s.";

    public void visitScript(ScriptTree tree) {
        for (Symbol symbol : this.getSymbols()) {
            this.visitSymbol(symbol);
        }
    }

    private Collection<Symbol> getSymbols() {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        Set symbols = symbolModel.getSymbols(Symbol.Kind.VARIABLE);
        symbols.addAll(symbolModel.getSymbols(Symbol.Kind.PARAMETER));
        return symbols;
    }

    private void visitSymbol(Symbol symbol) {
        Symbol outerSymbol;
        if ("arguments".equals(symbol.name()) && symbol.builtIn()) {
            return;
        }
        Scope scope = symbol.scope();
        if (scope.outer() != null && (outerSymbol = scope.outer().lookupSymbol(symbol.name())) != null && !outerSymbol.builtIn()) {
            String message = String.format(MESSAGE, symbol.name(), ((JavaScriptTree)VariableShadowingCheck.getDeclaration(outerSymbol).identifierTree()).getLine());
            this.raiseIssuesOnDeclarations(symbol, message);
        }
    }

    private void raiseIssuesOnDeclarations(Symbol symbol, String message) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration() && usage.kind() != Usage.Kind.LEXICAL_DECLARATION) continue;
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)usage.identifierTree(), message);
        }
    }

    private static Usage getDeclaration(Symbol symbol) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration() && usage.kind() != Usage.Kind.LEXICAL_DECLARATION) continue;
            return usage;
        }
        return (Usage)symbol.usages().iterator().next();
    }
}

