/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.FunctionReturns;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S3801")
public class ConsistentReturnsCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Refactor this function to use \"return\" consistently.";

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.copyOf((Collection)KindSet.FUNCTION_KINDS.getSubKinds());
    }

    public void visitNode(Tree tree) {
        BlockTree body;
        FunctionReturns functionReturns;
        FunctionTree functionTree = (FunctionTree)tree;
        if (functionTree.body().is(new Kinds[]{Tree.Kind.BLOCK}) && (functionReturns = FunctionReturns.getFunctionReturns(body = (BlockTree)functionTree.body())).containsReturnWithoutValue() && functionReturns.containsReturnWithValue()) {
            this.raiseIssue(tree, functionReturns, body);
        }
    }

    private void raiseIssue(Tree functionTree, FunctionReturns functionReturns, BlockTree body) {
        SyntaxToken tokenToRaiseIssue = functionTree.firstToken();
        if (functionTree.is(new Kinds[]{Tree.Kind.ARROW_FUNCTION})) {
            tokenToRaiseIssue = ((ArrowFunctionTree)functionTree).doubleArrowToken();
        }
        PreciseIssue issue = this.addIssue((Tree)tokenToRaiseIssue, MESSAGE);
        for (ReturnStatementTree returnStatement : functionReturns.returnStatements()) {
            issue.secondary((Tree)returnStatement.returnKeyword(), returnStatement.expression() == null ? "Return without value" : "Return with value");
        }
        if (functionReturns.containsImplicitReturn()) {
            issue.secondary((Tree)body.closeCurlyBraceToken(), "Implicit return without value");
        }
    }
}

