/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.KindSet;
import org.sonar.javascript.tree.impl.declaration.FunctionTreeImpl;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="FunctionDefinitionInsideLoop")
public class FunctionDefinitionInsideLoopCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Define this function outside of a loop.";
    private static final Set<String> ALLOWED_CALLBACKS = ImmutableSet.of((Object)"replace", (Object)"forEach", (Object)"filter", (Object)"map");
    private Deque<Tree> functionAndLoopScopes = new ArrayDeque<Tree>();

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.builder().addAll((Iterable)KindSet.LOOP_KINDS.getSubKinds()).addAll((Iterable)KindSet.FUNCTION_KINDS.getSubKinds()).build();
    }

    public void visitFile(Tree scriptTree) {
        this.functionAndLoopScopes.clear();
        this.functionAndLoopScopes.push(scriptTree);
    }

    public void visitNode(Tree tree) {
        FunctionTree functionTree;
        if (tree.is(new Kinds[]{KindSet.FUNCTION_KINDS}) && this.insideLoop() && !FunctionDefinitionInsideLoopCheck.isIIFE(functionTree = (FunctionTree)tree) && !FunctionDefinitionInsideLoopCheck.isAllowedCallback(functionTree) && FunctionDefinitionInsideLoopCheck.usesVariableFromOuterScope(functionTree, this.functionAndLoopScopes.peek())) {
            this.addIssue(FunctionDefinitionInsideLoopCheck.getTokenForIssueLocation(tree), MESSAGE);
        }
        this.functionAndLoopScopes.push(tree);
    }

    public void leaveNode(Tree tree) {
        this.functionAndLoopScopes.pop();
    }

    private static boolean isAllowedCallback(FunctionTree functionTree) {
        CallExpressionTree callExpression;
        Tree parent = functionTree.parent();
        if (parent.is(new Kinds[]{Tree.Kind.ARGUMENT_LIST}) && parent.parent().is(new Kinds[]{Tree.Kind.CALL_EXPRESSION}) && (callExpression = (CallExpressionTree)parent.parent()).callee().is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            String calledMethod = ((DotMemberExpressionTree)callExpression.callee()).property().name();
            return ALLOWED_CALLBACKS.contains(calledMethod);
        }
        return false;
    }

    private static boolean isIIFE(FunctionTree functionTree) {
        Tree parent = functionTree.parent();
        return parent.is(new Kinds[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && parent.parent().is(new Kinds[]{Tree.Kind.CALL_EXPRESSION, Tree.Kind.DOT_MEMBER_EXPRESSION});
    }

    private static Tree getTokenForIssueLocation(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.ARROW_FUNCTION})) {
            return ((ArrowFunctionTree)tree).doubleArrowToken();
        }
        return tree.firstToken();
    }

    private boolean insideLoop() {
        return this.functionAndLoopScopes.peek().is(new Kinds[]{KindSet.LOOP_KINDS});
    }

    private static boolean usesVariableFromOuterScope(FunctionTree functionTree, Tree loop) {
        return ((FunctionTreeImpl)functionTree).outerScopeSymbolUsages().map(Usage::symbol).filter(symbol -> !symbol.is(Symbol.Kind.LET_VARIABLE)).anyMatch(symbol -> !FunctionDefinitionInsideLoopCheck.hasConstValue(symbol, loop));
    }

    private static boolean hasConstValue(Symbol symbol, Tree loopTree) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration() && usage.isWrite()) {
                return false;
            }
            if (!usage.isDeclaration() || !usage.isWrite() || !loopTree.isAncestorOf((Tree)usage.identifierTree())) continue;
            return false;
        }
        return true;
    }
}

