/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S905")
public class UselessExpressionStatementCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Refactor or remove this statement.";
    private static final Set<String> KNOWN_DIRECTIVES = ImmutableSet.of((Object)"use strict", (Object)"$:nomunge", (Object)"ngInject");

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        Tree expression = tree.expression();
        if (expression.is(new Kinds[]{Tree.Kind.EQUAL_TO})) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        if (expression.is(new Kinds[]{Tree.Kind.STRING_LITERAL}) && !UselessExpressionStatementCheck.isDirective((LiteralTree)expression)) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitExpressionStatement(tree);
    }

    private static boolean isDirective(LiteralTree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.STRING_LITERAL})) {
            return KNOWN_DIRECTIVES.contains(UselessExpressionStatementCheck.trimQuotes(tree.value()));
        }
        return false;
    }

    private static String trimQuotes(String value) {
        return value.substring(1, value.length() - 1);
    }
}

