/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S2392")
public class WrongScopeDeclarationCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Move the declaration of \"%s\" to line %s.";

    public void visitScript(ScriptTree tree) {
        for (Symbol symbol : this.getContext().getSymbolModel().getSymbols()) {
            if (!symbol.isVariable() || symbol.external()) continue;
            this.visitSymbol(symbol);
        }
    }

    private void visitSymbol(Symbol symbol) {
        Scope declarationScope;
        Scope deepestCommonScope;
        Usage declaration = WrongScopeDeclarationCheck.getOnlyDeclaration(symbol);
        if (declaration != null && symbol.usages().size() > 1 && !(deepestCommonScope = WrongScopeDeclarationCheck.getDeepestCommonScope(symbol, declaration)).equals(declarationScope = declaration.identifierTree().scope()) && !WrongScopeDeclarationCheck.isFunctionException(deepestCommonScope, declarationScope)) {
            String message = String.format(MESSAGE, symbol.name(), deepestCommonScope.tree().firstToken().line() + 1);
            this.addIssue((Tree)declaration.identifierTree(), message);
        }
    }

    private static boolean isFunctionException(Scope deepestCommonScope, Scope declarationScope) {
        return !deepestCommonScope.isBlock() && WrongScopeDeclarationCheck.getScopeDepth(deepestCommonScope) > WrongScopeDeclarationCheck.getScopeDepth(declarationScope);
    }

    @CheckForNull
    private static Usage getOnlyDeclaration(Symbol symbol) {
        Usage declaration = null;
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration()) continue;
            if (declaration == null) {
                declaration = usage;
                continue;
            }
            return null;
        }
        return declaration;
    }

    private static int getScopeDepth(Scope scope) {
        int depth = 0;
        Scope currentScope = scope;
        while (!currentScope.isGlobal()) {
            currentScope = currentScope.outer();
            ++depth;
        }
        return depth;
    }

    private static Scope getDeepestCommonScope(Symbol symbol, Usage declaration) {
        HashSet usages = new HashSet(symbol.usages());
        if (!declaration.isWrite()) {
            usages.remove(declaration);
        }
        HashMap<Scope, Integer> scopeDepthMap = new HashMap<Scope, Integer>();
        for (Usage usage : usages) {
            Scope scope = usage.identifierTree().scope();
            scopeDepthMap.put(scope, WrongScopeDeclarationCheck.getScopeDepth(scope));
        }
        int minDepth = (Integer)Collections.min(scopeDepthMap.values());
        Set<Scope> sameDepthScopes = new HashSet<Scope>();
        for (Map.Entry entry : scopeDepthMap.entrySet()) {
            sameDepthScopes.add(WrongScopeDeclarationCheck.getAncestorScope((Scope)entry.getKey(), (Integer)entry.getValue() - minDepth));
        }
        while (sameDepthScopes.size() != 1) {
            sameDepthScopes = WrongScopeDeclarationCheck.outerScopes(sameDepthScopes);
        }
        return (Scope)sameDepthScopes.iterator().next();
    }

    private static Scope getAncestorScope(Scope scope, int levelsUp) {
        Scope currentScope = scope;
        for (int i = 0; i < levelsUp; ++i) {
            currentScope = currentScope.outer();
        }
        return currentScope;
    }

    private static Set<Scope> outerScopes(Set<Scope> scopes) {
        HashSet<Scope> result = new HashSet<Scope>();
        for (Scope scope : scopes) {
            result.add(scope.outer());
        }
        return result;
    }
}

